/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.common.geocaching.GeocacheCodeChecker;
import geocentral.common.geocaching.GeocacheSite;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.StringUtils;

public final class GeocacheCodeService {
    private static final GeocacheCodeService instance = new GeocacheCodeService();
    private final List<GeocacheCodeChecker> checkers = new LinkedList<GeocacheCodeChecker>();

    public static GeocacheCodeService getInstance() {
        return instance;
    }

    private GeocacheCodeService() {
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.GC));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OP));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OC));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OU));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OB));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OR));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OK));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OZ));
        this.checkers.add(new GeocacheCodeChecker(GeocacheSite.OX));
    }

    public GeocacheSite getSite(String code) {
        if (StringUtils.notEmpty(code = StringUtils.trim(code))) {
            code = StringUtils.toUpperCase(code);
            for (GeocacheCodeChecker checker : this.checkers) {
                if (!checker.checkCode(code)) continue;
                return checker.getSite();
            }
        }
        return GeocacheSite.UNKNOWN;
    }

    public boolean isValid(String code) {
        return !GeocacheSite.UNKNOWN.equals((Object)this.getSite(code));
    }
}

