/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.IGeocacheCodeChecker;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class GeocacheCodeChecker
implements IGeocacheCodeChecker {
    private static final String REGEX = "[A-Z0-9]{1,8}";
    private GeocacheSite site;
    private String prefix;

    public GeocacheCodeChecker(GeocacheSite site) {
        this(site, site != null ? site.name() : null);
    }

    public GeocacheCodeChecker(GeocacheSite site, String prefix) {
        AssertUtils.notNull((Object)site, "Site");
        AssertUtils.notEmpty(prefix, "Prefix");
        this.site = site;
        this.prefix = prefix;
    }

    @Override
    public GeocacheSite getSite() {
        return this.site;
    }

    @Override
    public boolean checkCode(String code) {
        String symbol;
        if (StringUtils.notEmpty(code) && StringUtils.startsWith(code, this.prefix) && StringUtils.notEmpty(symbol = code.substring(this.prefix.length()))) {
            return this.checkSymbol(symbol);
        }
        return false;
    }

    protected boolean checkSymbol(String symbol) {
        return symbol.matches(REGEX);
    }
}

