/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.app.SiteProfile;
import geocentral.common.app.UserProfile;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteType;
import geocentral.common.data.IDataItem;
import geocentral.common.data.IDataStore;
import geocentral.common.fieldnotes.FieldNoteSignatureUtils;
import geocentral.common.geocaching.DefaultGeocacheLogTypeMapper;
import geocentral.common.geocaching.GeocacheCodeService;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.items.Geocache;
import geocentral.common.items.GeocacheLog;
import geocentral.common.items.GeocacheUser;
import geocentral.common.items.WaypointItem;
import java.util.Date;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class GpxImportDataStore
implements IDataStore {
    private static final DefaultGeocacheLogTypeMapper logTypeMapper = new DefaultGeocacheLogTypeMapper();
    private final GeocacheCodeService codeService = GeocacheCodeService.getInstance();
    private final UserProfile profile;
    private final List<FieldNoteItem> fieldNotes;

    public GpxImportDataStore(UserProfile profile, List<FieldNoteItem> fieldNotes) {
        AssertUtils.notNull(profile, "User Profile");
        AssertUtils.notNull(fieldNotes, "Field Notes");
        this.profile = profile;
        this.fieldNotes = fieldNotes;
    }

    @Override
    public void putItem(IDataItem item) {
        if (item instanceof WaypointItem) {
            this.handleWaypoint((WaypointItem)item);
        } else if (item instanceof Geocache) {
            this.handleGeocache((Geocache)item);
        }
    }

    @Override
    public void flush() {
    }

    private void handleWaypoint(WaypointItem wpt) {
        GeocacheSite site = this.codeService.getSite(wpt.getName());
        if (GeocacheSite.isValid(site)) {
            FieldNoteItem meta = new FieldNoteItem();
            meta.setFieldNoteType(FieldNoteType.FILE);
            meta.setSite(site);
            meta.setGeocacheCode(wpt.getName());
            meta.setGeocacheName(wpt.getDescription());
            meta.setLogDate(new Date());
            meta.setLogType(GeocacheLogType.WRITE_NOTE);
            this.fieldNotes.add(meta);
        }
    }

    private void handleGeocache(Geocache gc) {
        GeocacheSite site = this.codeService.getSite(gc.getCode());
        if (GeocacheSite.isValid(site)) {
            List<GeocacheLog> logs;
            SiteProfile siteProfile = this.profile.getSiteProfile(site);
            boolean foundUserLog = false;
            if (siteProfile != null && (logs = gc.getLogs()) != null) {
                for (GeocacheLog log : logs) {
                    GeocacheUser user = log.getUser();
                    if (user == null || !StringUtils.equals(user.getSrcId(), siteProfile.getId())) continue;
                    Date logDate = log.getDate();
                    GeocacheLogType logType = logTypeMapper.getMappedValue(log.getType(), null);
                    if (logDate == null || logType == null) continue;
                    FieldNoteItem meta = this.createFromGeocache(site, gc);
                    meta.setLogDate(logDate);
                    meta.setLogType(logType);
                    meta.setLogText(StringUtils.trim(log.getText()));
                    if (!this.checkItem(meta)) continue;
                    this.fieldNotes.add(meta);
                    foundUserLog = true;
                }
            }
            if (!foundUserLog) {
                FieldNoteItem meta = this.createFromGeocache(site, gc);
                meta.setLogDate(new Date());
                meta.setLogType(GeocacheLogType.WRITE_NOTE);
                if (this.checkItem(meta)) {
                    this.fieldNotes.add(meta);
                }
            }
        }
    }

    private FieldNoteItem createFromGeocache(GeocacheSite site, Geocache gc) {
        FieldNoteItem meta = new FieldNoteItem();
        meta.setFieldNoteType(FieldNoteType.FILE);
        meta.setSite(site);
        meta.setType(gc.getType());
        meta.setGeocacheCode(gc.getCode());
        meta.setGeocacheName(gc.getName());
        GeocacheUser owner = gc.getOwner();
        if (owner != null) {
            meta.setGeocacheOwner(owner.getUsername());
        }
        meta.setRatingDifficulty(gc.getRatingDifficulty());
        meta.setRatingTerrain(gc.getRatingTerrain());
        meta.setSize(gc.getSize());
        meta.setHint(gc.getHint());
        return meta;
    }

    protected boolean checkItem(FieldNoteItem item) {
        item.setLogText(FieldNoteSignatureUtils.stripSignature(item.getLogText()));
        return true;
    }
}

