/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.bacza.http.URLUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.EnumUtils;
import org.bacza.utils.StringUtils;

public final class FieldNotesFormatUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static String formatDate(Date date) {
        if (date != null) {
            return DateUtils.formatDate(date, DATE_FORMAT, "GMT", Locale.UK);
        }
        return null;
    }

    public static String toString(List<FieldNoteItem> items) {
        if (items != null && items.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (FieldNoteItem item : items) {
                String data = FieldNotesFormatUtils.toString(item);
                if (data == null) continue;
                sb.append(data);
                sb.append(StringUtils.NEW_LINE);
            }
            return sb.toString();
        }
        return null;
    }

    public static String toString(FieldNoteItem item) {
        if (item == null) {
            return null;
        }
        if (item.getGeocacheCode() == null) {
            return null;
        }
        if (item.getLogDate() == null) {
            return null;
        }
        if (item.getLogType() == null) {
            return null;
        }
        String code = StringUtils.toUpperCase(item.getGeocacheCode());
        String date = FieldNotesFormatUtils.formatDate(item.getLogDate());
        String type = item.getLogType().text();
        String text = StringUtils.nvl(StringUtils.trim(item.getLogText()));
        return String.format("%s,%s,%s,\"%s\"", code, date, type, text);
    }

    public static String toXML(List<FieldNoteItem> items) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n", new Object[0]));
        sb.append(String.format("<geocentral>%n", new Object[0]));
        sb.append(String.format("\t<fieldnotes>%n", new Object[0]));
        for (FieldNoteItem item : items) {
            String data = FieldNotesFormatUtils.toXML(item);
            if (data == null) continue;
            sb.append(data);
        }
        sb.append(String.format("\t</fieldnotes>%n", new Object[0]));
        sb.append(String.format("</geocentral>%n", new Object[0]));
        return sb.toString();
    }

    public static String toXML(FieldNoteItem item) {
        if (item == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\t\t<fieldnote>%n", new Object[0]));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "item_type", EnumUtils.getName(item.getFieldNoteType()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "status", EnumUtils.getName(item.getFieldNoteStatus()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "site", item.getSite().name());
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "date", FieldNotesFormatUtils.formatDate(item.getLogDate()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "type", GeocacheLogType.getText(item.getLogType()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "comment", item.getLogText());
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "options", StringUtils.format(FieldNotesFormatUtils.calcOptions(item)));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "tag", item.getTag());
        if (item.isExistingLogChecked()) {
            FieldNotesFormatUtils.appendFieldNoteTag(sb, "existing_log_date", FieldNotesFormatUtils.formatDate(item.getExistingLogDate()));
            FieldNotesFormatUtils.appendFieldNoteTag(sb, "existing_log_type", GeocacheLogType.getText(item.getExistingLogType()));
            FieldNotesFormatUtils.appendFieldNoteTag(sb, "existing_log_checked", Boolean.toString(true));
        }
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "new_log_link", URLUtils.toASCIIString(item.getNewLogLink()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "compose_link", URLUtils.toASCIIString(item.getComposeLink()));
        FieldNotesFormatUtils.appendFieldNoteTag(sb, "delete_link", URLUtils.toASCIIString(item.getDeleteLink()));
        sb.append(String.format("\t\t\t<geocache>%n", new Object[0]));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "code", item.getGeocacheCode());
        FieldNotesFormatUtils.appendGeocacheTag(sb, "guid", item.getGuid());
        FieldNotesFormatUtils.appendGeocacheTag(sb, "name", item.getGeocacheName());
        FieldNotesFormatUtils.appendGeocacheTag(sb, "owner", item.getGeocacheOwner());
        FieldNotesFormatUtils.appendGeocacheTag(sb, "type", GeocacheType.getText(item.getType()));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "size", GeocacheSize.getText(item.getSize()));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "diff", StringUtils.format(item.getRatingDifficulty()));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "terr", StringUtils.format(item.getRatingTerrain()));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "fav_points", StringUtils.format(item.getFavPoints()));
        FieldNotesFormatUtils.appendGeocacheTag(sb, "hint", item.getHint());
        sb.append(String.format("\t\t\t</geocache>%n", new Object[0]));
        sb.append(String.format("\t\t</fieldnote>%n", new Object[0]));
        return sb.toString();
    }

    private static void appendFieldNoteTag(StringBuilder sb, String tag, String data) {
        if (StringUtils.notEmpty(data)) {
            sb.append(String.format("\t\t\t<%1$s>%2$s</%1$s>%n", tag, FieldNotesFormatUtils.escapeXml(data)));
        }
    }

    private static void appendGeocacheTag(StringBuilder sb, String tag, String data) {
        if (StringUtils.notEmpty(data)) {
            sb.append(String.format("\t\t\t\t<%1$s>%2$s</%1$s>%n", tag, FieldNotesFormatUtils.escapeXml(data)));
        }
    }

    private static String escapeXml(String str) {
        return StringEscapeUtils.escapeXml10((String)StringUtils.nvl(str));
    }

    private static Integer calcOptions(FieldNoteItem item) {
        int opt = 0;
        opt += item.getFavourite() ? 1 : 0;
        return (opt += item.getVisitTrackables() ? 2 : 0) > 0 ? new Integer(opt) : null;
    }
}

