/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.IFieldNoteDedupRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteDeduplicator {
    private List<FieldNoteItem> items;

    public FieldNoteDeduplicator(List<FieldNoteItem> items) {
        AssertUtils.notNull(items, "Items");
        this.items = items;
    }

    public int deduplicate(IFieldNoteDedupRule rule) {
        String key;
        AssertUtils.notNull(rule, "Rule");
        HashMap<String, LinkedList<FieldNoteItem>> duplicates = new HashMap<String, LinkedList<FieldNoteItem>>();
        HashMap<String, FieldNoteItem> prevs = new HashMap<String, FieldNoteItem>();
        for (FieldNoteItem item : this.items) {
            if (item == null || !rule.checkLogType(item.getLogType()) || !StringUtils.notEmpty(key = rule.getKey(item))) continue;
            FieldNoteItem prev = (FieldNoteItem)prevs.get(key);
            if (prev == null) {
                prevs.put(key, item);
                continue;
            }
            LinkedList<FieldNoteItem> list = (LinkedList<FieldNoteItem>)duplicates.get(key);
            if (list == null) {
                list = new LinkedList<FieldNoteItem>();
                list.add(prev);
                duplicates.put(key, list);
            }
            list.add(item);
        }
        prevs.clear();
        if (duplicates.size() > 0) {
            for (List list : duplicates.values()) {
                rule.deduplicate(list);
            }
            Iterator<FieldNoteItem> iter = this.items.iterator();
            while (iter.hasNext()) {
                List list;
                FieldNoteItem item = iter.next();
                if (!rule.checkLogType(item.getLogType()) || (list = (List)duplicates.get(key = rule.getKey(item))) == null || list.contains(item)) continue;
                iter.remove();
            }
        }
        return duplicates.size();
    }
}

