/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.FieldNoteItemLogDateComparator;
import geocentral.common.fieldnotes.IFieldNoteDedupRule;
import geocentral.common.geocaching.GeocacheLogType;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bacza.utils.DateUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteDedupRule3
implements IFieldNoteDedupRule {
    private static final FieldNoteItemLogDateComparator comparator = new FieldNoteItemLogDateComparator();

    @Override
    public String getRuleName() {
        return String.format(Messages.getString("FieldNoteDedupRule3.ruleName"), new Object[]{GeocacheLogType.DNF});
    }

    @Override
    public String getKey(FieldNoteItem item) {
        String code = StringUtils.nvl(item.getGeocacheCode(), item.getGuid());
        Date logDate = item.getLogDate();
        if (StringUtils.notEmpty(code) && logDate != null) {
            return String.format("%s-%s", code, DateUtils.formatDate(logDate));
        }
        return null;
    }

    @Override
    public boolean checkLogType(GeocacheLogType logType) {
        return logType == GeocacheLogType.DNF;
    }

    @Override
    public void deduplicate(List<FieldNoteItem> items) {
        if (items.size() > 1) {
            Collections.sort(items, comparator);
            FieldNoteItem last = items.get(items.size() - 1);
            items.clear();
            items.add(last);
        }
    }
}

