/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.FieldNoteItemLogDateComparator;
import geocentral.common.fieldnotes.IFieldNoteDedupRule;
import geocentral.common.geocaching.GeocacheLogType;
import java.util.Collections;
import java.util.List;
import org.bacza.utils.StringUtils;

public class FieldNoteDedupRule2
implements IFieldNoteDedupRule {
    private static final FieldNoteItemLogDateComparator comparator = new FieldNoteItemLogDateComparator();

    @Override
    public String getRuleName() {
        return String.format(Messages.getString("FieldNoteDedupRule2.ruleName"), new Object[]{GeocacheLogType.WILL_ATTEND});
    }

    @Override
    public String getKey(FieldNoteItem item) {
        return StringUtils.nvl(item.getGeocacheCode(), item.getGuid());
    }

    @Override
    public boolean checkLogType(GeocacheLogType logType) {
        return logType == GeocacheLogType.WILL_ATTEND;
    }

    @Override
    public void deduplicate(List<FieldNoteItem> items) {
        if (items.size() > 1) {
            Collections.sort(items, comparator);
            FieldNoteItem last = items.get(items.size() - 1);
            items.clear();
            items.add(last);
        }
    }
}

