/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FieldNoteCheckerDialog
extends TitleAreaDialog {
    private final IFieldNoteCheckRule rule;
    private final List<FieldNoteItem> items;

    public FieldNoteCheckerDialog(Shell parentShell, IFieldNoteCheckRule rule, List<FieldNoteItem> items) {
        super(parentShell);
        AssertUtils.notNull(rule, "Rule");
        AssertUtils.notNull(items, "Items");
        this.rule = rule;
        this.items = items;
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("FieldNoteChecker.titleWarning"));
        this.setMessage(Messages.getString("FieldNoteChecker.messageWarning"), 2);
        if (this.rule.isBlocking()) {
            this.setTitle(Messages.getString("FieldNoteChecker.titleError"));
            this.setMessage(Messages.getString("FieldNoteChecker.messageError"), 3);
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.horizontalSpacing = 14;
        gl_container.verticalSpacing = 10;
        gl_container.marginTop = 8;
        gl_container.marginRight = 16;
        gl_container.marginLeft = 16;
        container.setLayout((Layout)gl_container);
        Label lblRule = new Label(container, 0);
        lblRule.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblRule.setText(Messages.getString("FieldNoteChecker.ruleName"));
        Label lblRuleValue = new Label(container, 64);
        lblRuleValue.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRuleValue.setText(StringUtils.nvl(this.rule.getRuleName(), Messages.getString("FieldNoteChecker.noRuleName")));
        Label lblFieldNotes = new Label(container, 0);
        lblFieldNotes.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblFieldNotes.setText(Messages.getString("FieldNoteChecker.fieldNotesNumber"));
        Label lblFieldNotesValue = new Label(container, 0);
        lblFieldNotesValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblFieldNotesValue.setText(String.valueOf(this.items.size()));
        Text text = new Text(container, 2122);
        text.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        text.setText(StringUtils.nvl(this.rule.getRuleComment(), Messages.getString("FieldNoteChecker.noRuleComment")));
        new Label(container, 0);
        new Label(container, 0);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (!this.rule.isBlocking()) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 70, 19);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        return WidgetSizeUtils.getCenteredLocation((Control)this.getParentShell(), initialSize);
    }
}

