/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.fieldnotes.FieldNoteCheckRule0;
import geocentral.common.fieldnotes.FieldNoteCheckRule1;
import geocentral.common.fieldnotes.FieldNoteCheckRule10;
import geocentral.common.fieldnotes.FieldNoteCheckRule11;
import geocentral.common.fieldnotes.FieldNoteCheckRule2;
import geocentral.common.fieldnotes.FieldNoteCheckRule3;
import geocentral.common.fieldnotes.FieldNoteCheckRule4;
import geocentral.common.fieldnotes.FieldNoteCheckRule5;
import geocentral.common.fieldnotes.FieldNoteCheckRule6;
import geocentral.common.fieldnotes.FieldNoteCheckRule7;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bacza.utils.AssertUtils;

public final class FieldNoteCheckerConfig {
    private static final List<IFieldNoteCheckRule> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final FieldNoteCheckerConfig instance = new FieldNoteCheckerConfig();
    private final Map<GeocacheSite, List<IFieldNoteCheckRule>> rules = new HashMap<GeocacheSite, List<IFieldNoteCheckRule>>();

    private FieldNoteCheckerConfig() {
        this.init();
    }

    private void init() {
        FieldNoteCheckRule0 rule0 = new FieldNoteCheckRule0();
        FieldNoteCheckRule1 rule1 = new FieldNoteCheckRule1();
        FieldNoteCheckRule2 rule2 = new FieldNoteCheckRule2();
        FieldNoteCheckRule3 rule3 = new FieldNoteCheckRule3();
        FieldNoteCheckRule4 rule4GC = new FieldNoteCheckRule4(GeocacheSite.GC);
        FieldNoteCheckRule4 rule4OP = new FieldNoteCheckRule4(GeocacheSite.OP);
        FieldNoteCheckRule4 rule4OC = new FieldNoteCheckRule4(GeocacheSite.OC);
        FieldNoteCheckRule5 rule5 = new FieldNoteCheckRule5();
        FieldNoteCheckRule6 rule6 = new FieldNoteCheckRule6();
        FieldNoteCheckRule7 rule7 = new FieldNoteCheckRule7();
        FieldNoteCheckRule10 rule10 = new FieldNoteCheckRule10();
        FieldNoteCheckRule11 rule11 = new FieldNoteCheckRule11();
        this.registerRule(GeocacheSite.GC, rule7);
        this.registerRule(GeocacheSite.GC, rule0);
        this.registerRule(GeocacheSite.GC, rule1);
        this.registerRule(GeocacheSite.GC, rule2);
        this.registerRule(GeocacheSite.GC, rule3);
        this.registerRule(GeocacheSite.GC, rule4GC);
        this.registerRule(GeocacheSite.GC, rule10);
        this.registerRule(GeocacheSite.GC, rule11);
        this.registerRule(GeocacheSite.OP, rule7);
        this.registerRule(GeocacheSite.OP, rule0);
        this.registerRule(GeocacheSite.OP, rule1);
        this.registerRule(GeocacheSite.OP, rule4OP);
        this.registerRule(GeocacheSite.OP, rule5);
        this.registerRule(GeocacheSite.OP, rule6);
        this.registerRule(GeocacheSite.OP, rule10);
        this.registerRule(GeocacheSite.OP, rule11);
        this.registerRule(GeocacheSite.OC, rule7);
        this.registerRule(GeocacheSite.OC, rule0);
        this.registerRule(GeocacheSite.OC, rule1);
        this.registerRule(GeocacheSite.OC, rule4OC);
        this.registerRule(GeocacheSite.OC, rule5);
        this.registerRule(GeocacheSite.OC, rule6);
        this.registerRule(GeocacheSite.OC, rule10);
        this.registerRule(GeocacheSite.OC, rule11);
    }

    public static FieldNoteCheckerConfig getInstance() {
        return instance;
    }

    public synchronized void registerRule(GeocacheSite site, IFieldNoteCheckRule rule) {
        AssertUtils.notNull((Object)site, "Site");
        AssertUtils.notNull(rule, "Rule");
        List<IFieldNoteCheckRule> list = this.rules.get((Object)site);
        if (list == null) {
            list = new ArrayList<IFieldNoteCheckRule>();
            this.rules.put(site, list);
        }
        if (!list.contains(rule)) {
            list.add(rule);
        }
    }

    public synchronized List<IFieldNoteCheckRule> getRules(GeocacheSite site) {
        List<IFieldNoteCheckRule> result;
        if (site != null && (result = this.rules.get((Object)site)) != null) {
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }
}

