/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.ItemIterator;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheType;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bacza.utils.EnumUtils;

public class FieldNoteCheckRule6
implements IFieldNoteCheckRule {
    private static final GeocacheLogType[] eventLogTypes = new GeocacheLogType[]{GeocacheLogType.WILL_ATTEND, GeocacheLogType.ATTENDED, GeocacheLogType.WRITE_NOTE};
    private static final GeocacheLogType[] otherLogTypes = new GeocacheLogType[]{GeocacheLogType.FOUND_IT, GeocacheLogType.DNF, GeocacheLogType.WRITE_NOTE};

    @Override
    public String getRuleName() {
        return Messages.getString("FieldNoteCheckRule6.name");
    }

    @Override
    public String getRuleComment() {
        return String.format(Messages.getString("FieldNoteCheckRule6.comment"), StringUtils.join((Object[])eventLogTypes, (String)", "), StringUtils.join((Object[])otherLogTypes, (String)", "));
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public List<FieldNoteItem> check(ItemIterator<FieldNoteItem> iter) {
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        for (FieldNoteItem item : iter.getSelectedItems()) {
            GeocacheType type = item.getType();
            if (type == null) continue;
            if (type.isEvent()) {
                if (EnumUtils.equalsAny(item.getLogType(), eventLogTypes)) continue;
                result.add(item);
                continue;
            }
            if (EnumUtils.equalsAny(item.getLogType(), otherLogTypes)) continue;
            result.add(item);
        }
        return result;
    }
}

