/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.ItemIterator;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheLogTextConverter;
import geocentral.common.stats.GeocacheStatsManager;
import java.util.LinkedList;
import java.util.List;

public class FieldNoteCheckRule11
implements IFieldNoteCheckRule {
    @Override
    public String getRuleName() {
        return Messages.getString("FieldNoteCheckRule11.name");
    }

    @Override
    public String getRuleComment() {
        return Messages.getString("FieldNoteCheckRule11.comment");
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public List<FieldNoteItem> check(ItemIterator<FieldNoteItem> iter) {
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        GeocacheLogTextConverter converter = new GeocacheLogTextConverter();
        boolean hasTotalStatTokens = false;
        for (FieldNoteItem item : iter.getSelectedItems()) {
            if (item.getType() == null) {
                result.add(item);
            }
            if (hasTotalStatTokens || !converter.hasTokens(item.getLogText())) continue;
            List<String> tokens = converter.getValidTokens();
            for (String token : tokens) {
                if (!GeocacheStatsManager.isTotalStatToken(token)) continue;
                hasTotalStatTokens = true;
            }
        }
        if (!hasTotalStatTokens) {
            result.clear();
        }
        return result;
    }
}

