/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.documents;

import geocentral.common.documents.IDocumentProvider;
import geocentral.ui.views.View;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;

public final class DocumentService {
    private static final DocumentService instance = new DocumentService();
    private Map<String, IDocumentProvider> providers = new HashMap<String, IDocumentProvider>();

    private DocumentService() {
    }

    public static DocumentService getInstance() {
        return instance;
    }

    public void register(IDocumentProvider provider) {
        AssertUtils.notNull(provider, "Provider");
        String docTypeId = provider.getDocTypeId();
        AssertUtils.notNull(docTypeId, "Document Type ID");
        AssertUtils.checkState(!this.providers.containsKey(docTypeId), "Document Type ID already registered.");
        this.providers.put(docTypeId, provider);
    }

    public IDocumentProvider getProvider(String docTypeId) {
        AssertUtils.notNull(docTypeId, "Document Type ID");
        return this.providers.get(docTypeId);
    }

    public View createView(String docTypeId) {
        IDocumentProvider provider = this.getProvider(docTypeId);
        if (provider != null) {
            return provider.createView();
        }
        return null;
    }
}

