/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.parsers;

import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.IParserContext;
import geocentral.common.data.parsers.IUserParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParserImpl
extends DefaultHandler
implements IParserContext {
    private static final IAttributes EMPTY_ATTRS = new IAttributes(){

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public String getAttributeValue(String attrName) {
            return null;
        }
    };
    private Stack<ParserState> parsers = new Stack();
    private ParserState currentParser = new ParserState(null);
    private ParserState nextParser = null;
    private boolean continueParsing = true;
    private int skip = 0;

    public XmlParserImpl() {
    }

    public XmlParserImpl(IUserParser userParser) {
        this();
        this.installParser(userParser);
    }

    @Override
    public void installParser(IUserParser parser) throws IllegalArgumentException {
        if (parser == null) {
            throw new IllegalArgumentException("NULL parser.");
        }
        this.nextParser = new ParserState(parser);
    }

    @Override
    public void abort() {
        this.continueParsing = false;
    }

    private void startSubElementImpl(IAttributes attrs) {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (this.nextParser == null) {
            if (this.currentParser.temp) {
                this.skip = 2;
                return;
            }
            this.nextParser = new ParserState(new TempParser(this.currentParser.userParser), true);
        }
        this.parsers.push(this.currentParser);
        this.currentParser = this.nextParser;
        this.nextParser = null;
        this.skip = 0;
        this.currentParser.attrs = attrs;
        this.currentParser.userParser.setParserContext(this);
        this.currentParser.userParser.startProcessing();
    }

    private void endSubElementImpl() throws IllegalStateException {
        if (this.skip > 0) {
            --this.skip;
        }
        if (this.currentParser.nestedElements <= 0) {
            if (this.parsers.size() == 0) {
                throw new IllegalStateException("NULL parser.");
            }
            this.currentParser.userParser.stopProcessing();
            this.currentParser = this.parsers.pop();
            this.skip = 0;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.startSubElementImpl(null);
    }

    @Override
    public void endDocument() throws SAXException {
        this.endSubElementImpl();
        if (this.continueParsing && this.parsers.size() > 0) {
            throw new IllegalStateException("Invalid XML document.");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttrImpl attrs = null;
        if (this.skip == 0) {
            attrs = new AttrImpl(attributes);
            int i = qName.indexOf(58);
            int len = qName.length();
            if (i > 0 && i < len) {
                String name = qName.substring(i + 1);
                String xmlns = qName.substring(0, i);
                String xmluri = attributes.getValue("xmlns:" + xmlns);
                this.currentParser.userParser.startElement(name, xmlns, xmluri, attrs);
            } else {
                String xmluri = attributes.getValue("xmlns");
                this.currentParser.userParser.startElement(qName, null, xmluri, attrs);
            }
        }
        this.startSubElementImpl(attrs);
        ParserState parserState = this.currentParser;
        parserState.nestedElements = parserState.nestedElements + 1;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = null;
        if (this.skip == 0) {
            int i = qName.indexOf(58);
            int len = qName.length();
            name = i > 0 && i < len ? qName.substring(i + 1) : qName;
        }
        if (this.skip == 0 && this.currentParser.sb != null && this.currentParser.sb.length() > 0) {
            if (this.currentParser.temp) {
                this.currentParser.userParser.value(name, this.currentParser.sb.toString(), this.currentParser.attrs);
            }
            this.currentParser.sb.setLength(0);
        }
        ParserState parserState = this.currentParser;
        parserState.nestedElements = parserState.nestedElements - 1;
        this.endSubElementImpl();
        if (this.skip == 0) {
            this.currentParser.userParser.endElement(name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skip == 0) {
            this.currentParser.sb.append(ch, start, length);
        }
    }

    @Override
    public IAttributes getCurrentElementAttrs() {
        if (this.currentParser != null && this.currentParser.attrs != null) {
            return this.currentParser.attrs;
        }
        return EMPTY_ATTRS;
    }

    private class AttrImpl
    implements IAttributes {
        private Map<String, String> map = null;

        public AttrImpl(Attributes attrs) {
            int len;
            if (attrs != null && (len = attrs.getLength()) > 0) {
                this.map = new HashMap<String, String>(len);
                int i = 0;
                while (i < len) {
                    this.map.put(attrs.getQName(i), attrs.getValue(i));
                    ++i;
                }
            }
        }

        @Override
        public int getAttributeCount() {
            if (this.map != null) {
                return this.map.size();
            }
            return 0;
        }

        @Override
        public String getAttributeValue(String name) {
            if (this.map != null) {
                return this.map.get(name);
            }
            return null;
        }
    }

    private class ParserState {
        private IUserParser userParser;
        private int nestedElements;
        private StringBuilder sb;
        private boolean temp;
        private IAttributes attrs;

        ParserState(IUserParser userParser) {
            this(userParser, false);
        }

        ParserState(IUserParser userParser, boolean temp) {
            this.userParser = userParser;
            this.nestedElements = 0;
            this.sb = new StringBuilder(2046);
            this.temp = temp;
            this.attrs = null;
        }
    }

    private class TempParser
    implements IUserParser {
        private IUserParser userParser;

        public TempParser(IUserParser userParser) {
            this.userParser = userParser;
        }

        @Override
        public void setParserContext(IParserContext parserContext) {
        }

        @Override
        public void startProcessing() {
        }

        @Override
        public void stopProcessing() {
        }

        @Override
        public void startElement(String name) {
        }

        @Override
        public void startElement(String name, String namespace, String uri, IAttributes attrs) {
        }

        @Override
        public void endElement(String name) {
            if (this.userParser != null) {
                this.userParser.endElement(name);
            }
        }

        @Override
        public void value(String name, Object value, IAttributes attrs) {
            if (this.userParser != null) {
                this.userParser.value(name, value, attrs);
            }
        }

        @Override
        public void value(Object value) {
            if (this.userParser != null) {
                this.userParser.value(value);
            }
        }
    }
}

