/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.parsers;

import geocentral.common.actions.IActionContext;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.IParserContext;
import geocentral.common.data.parsers.IUserParser;

public class UserParser
implements IUserParser {
    protected DataReaderContext readerContext = null;
    private IParserContext parserContext = null;

    public UserParser(DataReaderContext readerContext) {
        this.readerContext = readerContext;
    }

    protected void installParser(IUserParser parser) {
        if (parser != null) {
            this.parserContext.installParser(parser);
        }
    }

    protected IAttributes getCurrentElementAttrs() {
        return this.parserContext.getCurrentElementAttrs();
    }

    protected void abort() {
        this.parserContext.abort();
    }

    protected boolean checkAbort() {
        boolean result = false;
        IActionContext ctx = this.readerContext.getActionContext();
        if (ctx != null && ctx.isCancelled()) {
            this.abort();
            result = true;
        }
        return result;
    }

    @Override
    public void setParserContext(IParserContext parserContext) {
        this.parserContext = parserContext;
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void stopProcessing() {
    }

    @Override
    public void startElement(String name) {
    }

    @Override
    public void startElement(String name, String namespace, String uri, IAttributes attrs) {
    }

    @Override
    public void endElement(String name) {
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
    }

    @Override
    public void value(Object value) {
    }

    protected static String getValueAsString(Object value) {
        String result = null;
        if (value instanceof String) {
            result = (String)value;
        } else if (value != null) {
            result = value.toString();
        }
        return result;
    }

    protected static Boolean getValueAsBoolean(Object value) {
        return UserParser.getValueAsBoolean(value, false);
    }

    protected static Boolean getValueAsBoolean(Object value, boolean parse) {
        Boolean result = null;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value instanceof String && parse) {
            result = Boolean.parseBoolean((String)value);
        }
        return result;
    }

    protected static Long getValueAsLong(Object value) {
        return UserParser.getValueAsLong(value, false);
    }

    protected static Long getValueAsLong(Object value, boolean parse) {
        Long result = null;
        if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof String && parse) {
            result = Long.parseLong((String)value);
        }
        return result;
    }

    protected static Integer getValueAsInt(Object value) {
        return UserParser.getValueAsInt(value, false);
    }

    protected static Integer getValueAsInt(Object value, boolean parse) {
        Integer result = null;
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (value instanceof String && parse) {
            result = Integer.parseInt((String)value);
        }
        return result;
    }

    protected static Double getValueAsDouble(Object value) {
        return UserParser.getValueAsDouble(value, false);
    }

    protected static Double getValueAsDouble(Object value, boolean parse) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Long) {
            return new Double(((Long)value).longValue());
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof String && parse) {
            return Double.parseDouble((String)value);
        }
        return null;
    }
}

