/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.parsers;

import geocentral.api.groundspeak.xml.GsDataParserPlugin;
import geocentral.api.opencaching.xml.OcDataParserPlugin;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.parsers.DataParserMeta;
import geocentral.common.data.parsers.IDataParserPlugin;
import geocentral.common.data.parsers.IUserParserFactory;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.plugins.AbstractPluginService;
import geocentral.files.gpx.GpxFileParserPlugin;
import java.util.HashMap;

public final class DataParserService
extends AbstractPluginService<IDataParserPlugin> {
    public static final String EXT_ID = "geocentral.common.dataParsers";
    private static final DataParserService instance = new DataParserService();
    private Object lock = new Object();
    private HashMap<String, IUserParserFactory> map = new HashMap();

    public static DataParserService getInstance() {
        return instance;
    }

    private DataParserService() {
        this.loadConfiguration(EXT_ID);
        this.initializePlugin(new GpxFileParserPlugin());
        this.initializePlugin(new GsDataParserPlugin());
        this.initializePlugin(new OcDataParserPlugin());
    }

    @Override
    protected void initializePlugin(IDataParserPlugin plugin) {
        DataParserMeta[] metas;
        if (plugin != null && (metas = plugin.getDataParserMeta()) != null) {
            DataParserMeta[] dataParserMetaArray = metas;
            int n = metas.length;
            int n2 = 0;
            while (n2 < n) {
                DataParserMeta meta = dataParserMetaArray[n2];
                if (meta != null) {
                    this.registerParser(meta.getElement(), meta.getNamespace(), meta.getFactory());
                }
                ++n2;
            }
        }
    }

    protected String getKey(String name, String namespace) {
        return String.format("%s::%s", name, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerParser(String name, String namespace, IUserParserFactory factory) {
        if (name != null && namespace != null && factory != null) {
            Object object = this.lock;
            synchronized (object) {
                String key = this.getKey(name, namespace);
                if (!this.map.containsKey(key)) {
                    this.map.put(key, factory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterParser(String name, String namespace) {
        if (name != null && namespace != null) {
            Object object = this.lock;
            synchronized (object) {
                String key = this.getKey(name, namespace);
                if (this.map.containsKey(key)) {
                    this.map.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserParser getParser(String name, String namespace, DataReaderContext readerContext) {
        UserParser result = null;
        if (name != null && readerContext != null) {
            IUserParserFactory factory = null;
            Object object = this.lock;
            synchronized (object) {
                String key = this.getKey(name, namespace);
                factory = this.map.get(key);
            }
            if (factory != null) {
                result = factory.createUserParser(readerContext);
            }
        }
        return result;
    }
}

