/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.files;

import geocentral.common.actions.AppContext;
import geocentral.common.actions.IActionSender;
import geocentral.common.data.files.FileReaderMeta;
import geocentral.common.data.files.FileReaderMetaComparator;
import geocentral.common.data.files.IFileReaderAsyncPlugin;
import geocentral.common.data.files.ReadFileAction;
import geocentral.common.data.files.ReadFileArgs;
import geocentral.common.plugins.AbstractPluginService;
import geocentral.common.plugins.AppContextService;
import geocentral.common.plugins.PluginExecutor2;
import geocentral.files.gpx.GpxFileReaderPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.StringUtils;
import org.eclipse.core.runtime.Path;

public final class FileReaderService
extends AbstractPluginService<IFileReaderAsyncPlugin> {
    private static final Log log = LogFactory.getLog(FileReaderService.class);
    public static final String EXT_ID = "geocentral.common.fileReaders";
    private static final FileReaderService instance = new FileReaderService();
    private HashMap<String, IFileReaderAsyncPlugin> readersByExt = new HashMap();
    private HashMap<FileReaderMeta, IFileReaderAsyncPlugin> readersByMeta = new HashMap();

    public static FileReaderService getInstance() {
        return instance;
    }

    private FileReaderService() {
        this.loadConfiguration(EXT_ID);
        this.registerFileReaderPlugin(new GpxFileReaderPlugin());
    }

    @Override
    protected void initializePlugin(IFileReaderAsyncPlugin plugin) {
        if (plugin != null) {
            this.registerFileReaderPlugin(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFileReaderPlugin(IFileReaderAsyncPlugin plugin) {
        FileReaderMeta[] metas = plugin.getFileReaderMeta();
        if (metas != null && metas.length > 0) {
            HashMap<String, IFileReaderAsyncPlugin> hashMap = this.readersByExt;
            synchronized (hashMap) {
                FileReaderMeta[] fileReaderMetaArray = metas;
                int n = metas.length;
                int n2 = 0;
                while (n2 < n) {
                    FileReaderMeta meta = fileReaderMetaArray[n2];
                    if (meta != null) {
                        String name = meta.getName();
                        String ext = meta.getExtension();
                        if (StringUtils.notEmpty(name) && StringUtils.notEmpty(ext) && !this.readersByExt.containsKey(ext = ext.toLowerCase())) {
                            this.readersByExt.put(ext, plugin);
                            this.readersByMeta.put(meta, plugin);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileReaderMeta> getFileReaderMeta() {
        LinkedList<FileReaderMeta> result = new LinkedList<FileReaderMeta>();
        HashMap<String, IFileReaderAsyncPlugin> hashMap = this.readersByExt;
        synchronized (hashMap) {
            result.addAll(this.readersByMeta.keySet());
        }
        Collections.sort(result, new FileReaderMetaComparator());
        return result;
    }

    public void readAction(ReadFileArgs args, IActionSender sender) {
        this.readActionImpl(args, AppContextService.getInstance().createAppContext(sender));
    }

    public void readAction(ReadFileArgs args, AppContext appContext) {
        this.readActionImpl(args, appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readActionImpl(ReadFileArgs args, AppContext appContext) {
        Path path;
        String extension;
        String file;
        if (args != null && StringUtils.notEmpty(file = args.getFilename()) && StringUtils.notEmpty(extension = (path = new Path(file)).getFileExtension())) {
            IFileReaderAsyncPlugin plugin = null;
            HashMap<String, IFileReaderAsyncPlugin> hashMap = this.readersByExt;
            synchronized (hashMap) {
                extension = extension.toLowerCase();
                plugin = this.readersByExt.get(extension);
            }
            if (plugin != null) {
                ReadFileAction action = new ReadFileAction(args);
                PluginExecutor2.getInstance().executeAsync(plugin, action, appContext);
            } else {
                log.debug((Object)("No file reader found for file type: " + extension));
            }
        }
    }
}

