/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bacza.utils.AssertUtils;

public class ItemIterator<I> {
    protected final List<I> allItems;
    protected final List<I> selectedItems;
    protected final Set<I> selectedItemsSet;
    protected Iterator<I> iter;
    protected I currentItem;

    public ItemIterator(List<I> allItems, List<I> selectedItems) {
        AssertUtils.notNull(allItems, "All items");
        AssertUtils.notNull(selectedItems, "Selected items");
        this.allItems = new ArrayList<I>(allItems);
        this.selectedItems = new ArrayList<I>(selectedItems);
        this.selectedItemsSet = new HashSet<I>(selectedItems);
        this.reset();
    }

    public ItemIterator(ItemIterator<I> iterator) {
        this(iterator != null ? iterator.allItems : null, iterator != null ? iterator.selectedItems : null);
    }

    public void reset() {
        this.iter = this.allItems.iterator();
        this.currentItem = null;
    }

    public List<I> getAllItems() {
        return Collections.unmodifiableList(this.allItems);
    }

    public List<I> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public I next() {
        this.currentItem = this.iter.next();
        return this.currentItem;
    }

    public boolean isSelected() {
        return this.selectedItemsSet.contains(this.currentItem);
    }

    public void sort(Comparator<I> comparator) {
        AssertUtils.notNull(comparator, "Comparator");
        Collections.sort(this.allItems, comparator);
        this.reset();
    }
}

