/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.data.IDataItem;
import geocentral.common.data.IDataStore;
import geocentral.common.data.IDataStoreHelper;
import java.util.HashMap;

public class DataStoreHelper
implements IDataStoreHelper {
    private IDataStore dataStore;
    private HashMap<Class<? extends IDataItem>, Counter> countsByItem;

    public DataStoreHelper(IDataStore dataStore) {
        this.dataStore = dataStore;
        this.countsByItem = new HashMap(10);
    }

    @Override
    public void putItem(IDataItem item) {
        if (item != null) {
            this.getCounterImpl(null).incrementCount();
            this.getCounterImpl(item.getClass()).incrementCount();
            if (this.dataStore != null) {
                this.dataStore.putItem(item);
            }
        }
    }

    @Override
    public void flush() {
        if (this.dataStore != null) {
            this.dataStore.flush();
        }
    }

    @Override
    public int getCounter() {
        return this.getCounter(null);
    }

    @Override
    public int getCounter(Class<? extends IDataItem> clazz) {
        return this.getCounterImpl(clazz).getCount();
    }

    private Counter getCounterImpl(Class<? extends IDataItem> clazz) {
        Counter counter = this.countsByItem.get(clazz);
        if (counter == null) {
            counter = new Counter();
            this.countsByItem.put(clazz, counter);
        }
        return counter;
    }

    private class Counter {
        private int count = 0;

        private Counter() {
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }
    }
}

