/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.actions.IActionContext;
import geocentral.common.data.DataReaderResult;
import geocentral.common.data.DataStoreHelper;
import geocentral.common.data.IDataItem;
import geocentral.common.data.IDataReaderContext;
import geocentral.common.data.IDataStore;
import geocentral.common.data.IDataStoreHelper;
import java.util.Stack;
import org.bacza.utils.AssertUtils;

public class DataReaderContext
implements IDataReaderContext {
    private IActionContext actionContext;
    private IDataStoreHelper dataStore;
    private Stack<IDataItem> stack;
    private DataReaderResult result;

    public DataReaderContext(IActionContext actionContext) {
        this(actionContext, null);
    }

    public DataReaderContext(IActionContext actionContext, IDataStore dataStore) {
        this.init(actionContext, dataStore, new Stack<IDataItem>());
    }

    public DataReaderContext(DataReaderContext dataReaderContext, IDataStore dataStore) {
        AssertUtils.checkArgument(dataReaderContext != null, "Data reader context is null");
        this.init(dataReaderContext.actionContext, dataStore, dataReaderContext.stack);
    }

    private void init(IActionContext actionContext, IDataStore dataStore, Stack<IDataItem> stack) {
        AssertUtils.checkArgument(actionContext != null, "Action context is null");
        this.actionContext = actionContext;
        this.dataStore = new DataStoreHelper(dataStore);
        this.stack = stack;
        this.result = null;
    }

    @Override
    public IActionContext getActionContext() {
        return this.actionContext;
    }

    @Override
    public IDataStoreHelper getDataStore() {
        return this.dataStore;
    }

    public void setResult(DataReaderResult result) {
        this.result = result;
    }

    public DataReaderResult getResult() {
        return this.result;
    }

    @Override
    public void pushItem(IDataItem item) {
        if (item != null) {
            this.stack.push(item);
        }
    }

    @Override
    public IDataItem popItem() {
        IDataItem result = null;
        if (this.stack.size() > 0) {
            result = this.stack.pop();
        }
        return result;
    }

    @Override
    public IDataItem peekItem() {
        IDataItem result = null;
        if (this.stack.size() > 0) {
            result = this.stack.peek();
        }
        return result;
    }

    @Override
    public int getStackSize() {
        return this.stack.size();
    }
}

