/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.data.DataModel;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;

public final class DataModelService {
    private static final DataModelService instance = new DataModelService();
    private Map<String, DataModel<?>> map = new HashMap();

    private DataModelService() {
    }

    public static DataModelService getInstance() {
        return instance;
    }

    public DataModel<?> getDataModel(String docId) {
        if (docId != null) {
            return this.map.get(docId);
        }
        return null;
    }

    public void registerDataModel(String docId, DataModel<?> dataModel) {
        AssertUtils.notNull(docId, "Document ID");
        AssertUtils.notNull(dataModel, "Data Model");
        this.map.put(docId, dataModel);
    }

    public void unregisterDataModel(String docId) {
        if (docId != null) {
            this.map.remove(docId);
        }
    }
}

