/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.data.IValueMapper;
import java.util.HashMap;

public abstract class AbstractValueMapper<K, V>
implements IValueMapper<K, V> {
    private HashMap<K, V> map = new HashMap();
    private V defaultValue = this.getDefaultValue();

    public AbstractValueMapper() {
        this.initialize();
    }

    protected abstract void initialize();

    protected abstract V getDefaultValue();

    protected void setMappedValue(K key, V value) {
        if (key != null && value != null) {
            this.map.put(this.transformKey(key), value);
        }
    }

    protected K transformKey(K key) {
        return key;
    }

    @Override
    public V getMappedValue(K key) {
        return this.getMappedValue(key, this.defaultValue);
    }

    @Override
    public V getMappedValue(K key, V defaultValue) {
        V result = null;
        if (key != null) {
            result = this.map.get(this.transformKey(key));
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }
}

