/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.UsageEvent;
import geocentral.common.app.UsageQueue;
import geocentral.common.app.WebConnectService;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.ThreadUtils;
import org.json.JSONException;

public class UsageSync {
    private final UsageQueue queue;
    private final Thread thread;
    private boolean stopped;

    public UsageSync(UsageQueue queue) {
        AssertUtils.notNull(queue, "UsageQueue");
        this.queue = queue;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                UsageSync.this.execute();
            }
        }, "Usage Sync");
        this.stopped = false;
    }

    private void execute() {
        ThreadUtils.sleep(1000L);
        WebConnectService conn = WebConnectService.getInstance();
        while (!this.stopped) {
            UsageEvent event = this.queue.getEvent();
            if (event == null) continue;
            if (this.stopped) break;
            while (!this.stopped && !conn.waitForConnection()) {
            }
            if (this.stopped) break;
            try {
                conn.send("usage", event.toJSON());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public synchronized void start() {
        if (this.thread.getState().equals((Object)Thread.State.NEW)) {
            this.thread.start();
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.thread.interrupt();
    }
}

