/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.UserProfile;
import java.util.Date;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class UsageEvent {
    private static final int ATTR_MAX = 9;
    private final UserProfile profile;
    private final Date timestamp;
    private final String category;
    private final String action;
    private final String label;
    private final String[] attrs;

    public UsageEvent(UserProfile profile, String category, String action) {
        this(profile, category, action, null);
    }

    public UsageEvent(UserProfile profile, String category, String action, String label) {
        this(profile, category, action, label, null);
    }

    public UsageEvent(UserProfile profile, String category, String action, String label, String ... attrs) {
        AssertUtils.notNull(profile, "Profile");
        AssertUtils.notEmpty(category, "Category");
        AssertUtils.notEmpty(action, "Action");
        this.profile = profile;
        this.timestamp = new Date();
        this.category = category;
        this.action = action;
        this.label = label;
        this.attrs = attrs;
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAction() {
        return this.action;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public String toString() {
        return String.format("%s, %s, %s", this.category, this.action, this.label);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("userid", (Object)this.profile.getUUID());
        obj.put("timestamp", (Object)DateUtils.formatDateGMTExt(this.timestamp));
        obj.put("category", (Object)this.category);
        obj.put("action", (Object)this.action);
        obj.put("label", (Object)this.label);
        if (this.attrs != null) {
            int i = 0;
            while (i < this.attrs.length && i < 9) {
                obj.put(String.format("value%d", i + 1), (Object)this.attrs[i]);
                ++i;
            }
        }
        return obj;
    }
}

