/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.StorageService;
import geocentral.common.data.IChangeEventSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringUtils;

public final class SystemConfigService
implements IChangeEventSource {
    public static final String FILENAME = "system.ini";
    private static final Log log = LogFactory.getLog(SystemConfigService.class);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final Properties props = new Properties();
    private static final SystemConfigService instance = new SystemConfigService();

    private SystemConfigService() {
        this.load();
    }

    public static SystemConfigService getInstance() {
        return instance;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void notifyChange() {
        this.notifyChange("*");
    }

    private void notifyChange(String id) {
        this.changeSupport.firePropertyChange(id, 0, 1);
    }

    private String getFilename() {
        return StorageService.getInstance().getSystemPath(FILENAME);
    }

    private String getFileDesc() {
        return "GeoCentral system config file.";
    }

    public synchronized void load() {
        String filename = this.getFilename();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream stream = new FileInputStream(filename);){
                this.props.clear();
                this.props.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            log.trace((Object)String.format("Config file not found: %s", filename));
        }
        catch (IOException e) {
            log.debug((Object)"Exception", (Throwable)e);
        }
    }

    public synchronized void save() {
        String filename = this.getFilename();
        try {
            FileUtils.createPath(filename, true);
        }
        catch (IOException e) {
            log.debug((Object)String.format("Could not create config file: %s", filename), (Throwable)e);
            return;
        }
        try {
            Throwable e = null;
            Object var3_7 = null;
            try (FileOutputStream stream = new FileOutputStream(filename);){
                this.props.store(stream, this.getFileDesc());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            log.debug((Object)String.format("Config file not found: %s", filename));
        }
        catch (IOException e) {
            log.debug((Object)"Exception", (Throwable)e);
        }
    }

    public synchronized void setString(String key, String value) {
        if (StringUtils.notEmpty(key)) {
            this.props.setProperty(key, StringUtils.nvl(value));
            this.notifyChange(key);
        }
    }

    public synchronized String getString(String key) {
        return this.props.getProperty(key);
    }

    public synchronized String getString(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public synchronized void setBoolean(String key, Boolean value) {
        if (StringUtils.notEmpty(key)) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            this.props.setProperty(key, value.toString());
            this.notifyChange(key);
        }
    }

    public synchronized Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.props.getProperty(key, null);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }
}

