/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.geocaching.GeocacheSite;
import java.net.URI;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class SiteProfile {
    private final GeocacheSite site;
    private final String id;
    private final String uuid;
    private final String login;
    private String type;
    private URI avatarLink;

    public SiteProfile(GeocacheSite site, String id, String uuid, String login) {
        AssertUtils.notNull((Object)site, "site");
        AssertUtils.checkArgument(StringUtils.notEmpty(id) || StringUtils.notEmpty(uuid), "At least one ID must be given.");
        AssertUtils.notEmpty(login, "login");
        this.site = site;
        this.id = id;
        this.uuid = uuid;
        this.login = login;
    }

    public GeocacheSite getSite() {
        return this.site;
    }

    public String getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getLogin() {
        return this.login;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public URI getAvatarLink() {
        return this.avatarLink;
    }

    public void setAvatarLink(URI avatarLink) {
        this.avatarLink = avatarLink;
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.site, this.login});
    }
}

