/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bacza.utils.AssertUtils;

public final class SchedulerService {
    private static final int MAX_THREADS = 4;
    private static final SchedulerService instance = new SchedulerService();
    private final ScheduledExecutorService ses = Executors.newScheduledThreadPool(4);

    public static SchedulerService getInstance() {
        return instance;
    }

    private SchedulerService() {
    }

    public ScheduledFuture<?> schedule(Runnable task, long initialDelay) {
        AssertUtils.notNull(task, "task");
        return this.ses.schedule(task, initialDelay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay) {
        AssertUtils.notNull(task, "task");
        return this.ses.scheduleWithFixedDelay(task, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.ses.shutdownNow();
    }
}

