/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.LoggerOverride;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.bacza.utils.AssertUtils;

public class LoggerFilter
implements Filter {
    private List<LoggerOverride> overrides;
    private Map<String, Level> levels;

    public LoggerFilter(List<LoggerOverride> overrides) {
        AssertUtils.notNull(overrides, "Overrides");
        this.overrides = new ArrayList<LoggerOverride>(overrides);
        this.levels = new HashMap<String, Level>();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String name = record.getLoggerName();
        if (name == null) {
            return true;
        }
        Level currLevel = record.getLevel();
        if (currLevel == null) {
            return true;
        }
        Level overLevel = this.levels.get(name);
        if (overLevel == null) {
            overLevel = this.calcOverrideLevel(name, currLevel);
        }
        return currLevel.intValue() >= overLevel.intValue();
    }

    private Level calcOverrideLevel(String name, Level currLevel) {
        Level result = currLevel;
        for (LoggerOverride over : this.overrides) {
            if (!name.startsWith(over.getName())) continue;
            result = over.getLevel();
        }
        return result;
    }
}

