/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.BMCNotifier;
import geocentral.common.app.SiteProfile;
import geocentral.common.app.SystemData;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileListener;
import geocentral.common.app.UserProfileService;
import geocentral.common.app.WebConnectService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.StringUtils;
import org.bacza.utils.ThreadUtils;
import org.json.JSONObject;

public final class AppConfigService {
    private static final Log log = LogFactory.getLog(AppConfigService.class);
    private static final String SYS_MSG_APPCONFIG = "appconfig";
    private static final AppConfigService instance = new AppConfigService();
    private BMCHelper _bmc = new BMCHelper();

    public static AppConfigService getInstance() {
        return instance;
    }

    private AppConfigService() {
        UserProfileService.getInstance().addListener(new UserProfileListener(){

            @Override
            public void currentUser(UserProfile profile) {
            }

            @Override
            public void userLogin(UserProfile profile) {
                ThreadUtils.exec(new Runnable(){

                    @Override
                    public void run() {
                        AppConfigService.this.initBMC(true);
                    }
                });
            }

            @Override
            public void userLogout(UserProfile profile) {
            }

            @Override
            public void siteAdded(UserProfile userProfile, SiteProfile siteProfile) {
            }

            @Override
            public void siteRemoved(UserProfile userProfile, SiteProfile siteProfile) {
            }
        });
        WebConnectService.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String type = event.getPropertyName();
                if (StringUtils.equals(type, AppConfigService.SYS_MSG_APPCONFIG)) {
                    AppConfigService.this.saveAppConfig();
                    AppConfigService.this.initBMC();
                }
            }
        });
    }

    private synchronized void saveAppConfig() {
        String appid = UserProfileService.getInstance().getAppId();
        JSONObject appconfig = WebConnectService.getInstance().getSystemMessage(SYS_MSG_APPCONFIG);
        if (appconfig == null) {
            return;
        }
        int scn = appconfig.optInt("scn", -1);
        if (scn < 0) {
            return;
        }
        JSONObject appconfig2 = SystemData.getAppConfig(appid);
        if (appconfig2 == null) {
            SystemData.setAppConfig(appid, appconfig);
            return;
        }
        int scn2 = appconfig2.optInt("scn", -1);
        if (scn > scn2) {
            SystemData.setAppConfig(appid, appconfig);
        }
    }

    private synchronized void initBMC() {
        this.initBMC(false);
    }

    private synchronized void initBMC(boolean reset) {
        BMCData bmcApp;
        if (reset) {
            this._bmc.reset();
        }
        String appid = UserProfileService.getInstance().getAppId();
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        if (UserProfileService.getInstance().isDefaultProfile(profile)) {
            return;
        }
        JSONObject appconfig = SystemData.getAppConfig(appid);
        if (appconfig == null) {
            return;
        }
        JSONObject json = appconfig.optJSONObject("bmc");
        BMCData bMCData = bmcApp = json != null ? new BMCData(json) : new BMCData(0, false);
        if (!this._bmc.setBmcApp(bmcApp)) {
            return;
        }
        this._bmc.loadNoti();
        this.tickBMC(1);
    }

    public synchronized void tickBMC(int ticks) {
        this.tickBMC(ticks, false);
    }

    public synchronized void tickBMC(int ticks, boolean sync) {
        if (this._bmc.initialized() && this._bmc.shouldNotify(ticks, sync)) {
            this._bmc.doNotify();
        }
    }

    public class BMCData {
        private int scn;
        private boolean paid;

        public BMCData() {
            this(-1, false);
        }

        public BMCData(BMCData bmc) {
            this(bmc.scn, bmc.paid);
        }

        public BMCData(JSONObject json) {
            this(-1, false);
            if (json != null) {
                this.scn = json.optInt("scn", -1);
                this.paid = json.optBoolean("paid", false);
            }
        }

        public BMCData(int scn, boolean paid) {
            this.scn = scn;
            this.paid = paid;
        }

        public boolean initialized() {
            return this.scn >= 0;
        }

        public String toString() {
            return String.format("scn=%d, paid=%b", this.scn, this.paid);
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            json.put("scn", this.scn);
            json.put("paid", this.paid);
            return json;
        }
    }

    private class BMCHelper {
        private final BMCNotifier bmcNotifier = new BMCNotifier();
        private BMCData bmcApp;
        private BMCData bmcNoti;
        private int counter;

        public BMCHelper() {
            this.reset();
        }

        public boolean initialized() {
            return this.bmcApp.initialized();
        }

        public void reset() {
            this.bmcApp = new BMCData();
            this.bmcNoti = new BMCData();
            this.counter = 0;
        }

        public boolean setBmcApp(BMCData bmc) {
            if (this.bmcApp.scn >= bmc.scn) {
                return false;
            }
            this.bmcApp = bmc;
            this.counter = 0;
            return true;
        }

        public boolean hasNewConfig() {
            return this.bmcApp.scn > this.bmcNoti.scn;
        }

        public boolean hasPayment() {
            return this.bmcApp.paid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldNotify(int ticks, boolean sync) {
            if (!sync) {
                return this.shouldNotifyImpl(ticks);
            }
            Object object = BMCNotifier.lock;
            synchronized (object) {
                return this.shouldNotifyImpl(ticks);
            }
        }

        private boolean shouldNotifyImpl(int ticks) {
            boolean counterOK;
            if (this.counter >= 1000) {
                this.counter = 0;
            }
            boolean bl = counterOK = this.counter == 0;
            if (ticks < 1) {
                ticks = 1;
            }
            this.counter += ticks;
            return counterOK && (this.hasNewConfig() || !this.hasPayment());
        }

        public void doNotify() {
            if (this.hasNewConfig()) {
                this.bmcNoti = new BMCData(this.bmcApp);
                this.saveNoti();
            }
            this.bmcNotifier.show(this.hasPayment());
        }

        public void loadNoti() {
            String appid = UserProfileService.getInstance().getAppId();
            this.bmcNoti = new BMCData(SystemData.getAppNotification(appid, "bmc"));
        }

        public void saveNoti() {
            String appid = UserProfileService.getInstance().getAppId();
            SystemData.setAppNotification(appid, "bmc", this.bmcNoti.toJSON());
        }
    }
}

