/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common;

import geocentral.common.app.LanguageListener;
import geocentral.common.app.LanguageService;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Messages {
    private static final String PATH = "geocentral.common.Messages";
    private static ResourceBundle bundle = Messages.getBundle();

    static {
        LanguageService.getInstance().addListener(new LanguageListener(){

            @Override
            public void languageChanged(String tag) {
                bundle = Messages.getBundle();
            }
        });
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(PATH);
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String format(String key, Object ... args) {
        return MessageFormat.format(Messages.getString(key), args);
    }
}

