/*
 * Decompiled with CFR 0.152.
 */
package geocentral.app;

import geocentral.app.Geocentral;
import geocentral.app.SysConst;
import geocentral.common.Messages;
import geocentral.common.app.AppConfigService;
import geocentral.common.app.ConfigDataService;
import geocentral.common.app.ConfigManager;
import geocentral.common.app.LanguageService;
import geocentral.common.app.LoggerManager;
import geocentral.common.app.StorageService;
import geocentral.common.app.SystemConfigService;
import geocentral.common.app.UsageEvent;
import geocentral.common.app.UsageService;
import geocentral.common.app.UsageServiceUtils;
import geocentral.common.app.UserProfileService;
import geocentral.common.scripting.ScriptingManager;
import geocentral.common.ui.DisplayUtils;
import geocentral.http.WebClientManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public final class Main {
    private static final Log log;

    static {
        String key = "swt.autoScale";
        String value = System.getProperty("swt.autoScale");
        if (value == null || value.trim().isEmpty()) {
            System.setProperty("swt.autoScale", "false");
        }
        LanguageService.getInstance();
        LoggerManager.getInstance().configure();
        log = LogFactory.getLog(Main.class);
    }

    public static void main(String[] args) {
        block9: {
            log.info((Object)String.format("Starting %s version %s...", "GeoCentral Lite", "1.0.16"));
            log.info((Object)String.format("Running: %s, %s", SysConst.OS_BANNER, SysConst.JAVA_BANNER));
            try {
                Display.setAppName((String)"GeoCentral Lite");
                Display.setAppVersion((String)"1.0.16");
                if (StorageService.getInstance().createLockFile()) {
                    Main.run();
                } else {
                    Main.showError(Messages.getString("Geocentral.anotherInstanceRunning"));
                    log.info((Object)"Another instance already running, exiting...");
                }
            }
            catch (LinkageError e) {
                log.fatal((Object)"Fatal linkage error!", (Throwable)e);
                SWTResourceManager.dispose();
                break block9;
            }
            catch (Throwable e) {
                try {
                    log.fatal((Object)"Fatal error!", e);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SWTResourceManager.dispose();
                }
            }
            SWTResourceManager.dispose();
        }
        log.info((Object)"Stopped.");
        StorageService.getInstance().removeLockFile();
        System.exit(0);
    }

    private static void run() {
        UsageServiceUtils.event(new UsageEvent(UserProfileService.getInstance().getCurrentProfile(), "app", "started", "1.0.16", SysConst.OS_NAME, SysConst.OS_ARCH, SysConst.JAVA_SPEC_VERSION));
        try {
            StorageService.getInstance();
            UserProfileService.getInstance();
            SystemConfigService.getInstance();
            ConfigManager.getInstance();
            ScriptingManager.getInstance();
            AppConfigService.getInstance();
            Geocentral window = new Geocentral();
            window.setBlockOnOpen(true);
            window.open();
            Display.getCurrent().dispose();
        }
        finally {
            ConfigManager.getInstance().save();
            SystemConfigService.getInstance().save();
            ConfigDataService.getInstance().shutdown();
            UsageService.getInstance().shutdown();
            WebClientManager.getInstance().shutdown();
        }
    }

    private static void showError(String message) {
        Display display = DisplayUtils.getDisplay();
        Shell s = new Shell(display);
        MessageBox dialog = new MessageBox(s, 33);
        dialog.setText("GeoCentral Lite");
        dialog.setMessage(message);
        dialog.open();
        s.dispose();
    }
}

