/*
 * Decompiled with CFR 0.152.
 */
package geocentral.app;

import ca.odell.glazedlists.EventList;
import geocentral.api.groundspeak.ui.FieldNotesProvider;
import geocentral.api.groundspeak.ui.actions.LogoutAction;
import geocentral.app.AboutDialog;
import geocentral.common.GlobalUtils;
import geocentral.common.Messages;
import geocentral.common.app.ConfigDataService;
import geocentral.common.app.ConfigManager;
import geocentral.common.app.IConfigData;
import geocentral.common.app.LanguageListener;
import geocentral.common.app.LanguageService;
import geocentral.common.app.SiteProfile;
import geocentral.common.app.Sysmon;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileListener;
import geocentral.common.app.UserProfileService;
import geocentral.common.app.VersionUtils;
import geocentral.common.app.WebConnectService;
import geocentral.common.data.DataModel;
import geocentral.common.data.DataModelService;
import geocentral.common.data.FieldNoteDataModel;
import geocentral.common.data.IChangeEventSource;
import geocentral.common.documents.DocumentService;
import geocentral.common.documents.IDocumentProvider;
import geocentral.common.fieldnotes.FieldNoteImportUtils;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.plugins.PluginExecutor;
import geocentral.common.scripting.ScriptingManager;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.FileDialogUtils;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ui.SWTUtils;
import geocentral.common.ui.dialogs.LanguageDialog;
import geocentral.common.ui.dialogs.NewVersionDialog;
import geocentral.common.ui.dialogs.OAuthLoginDialog;
import geocentral.common.ui.dialogs.PasswordLoginDialog;
import geocentral.common.ui.dialogs.SelectProfileDialog;
import geocentral.common.ui.dialogs.SiteLoginDialog;
import geocentral.common.ui.preferences.Preferences;
import geocentral.common.ws.SiteLoginAction;
import geocentral.ui.views.IMenuItemProvider;
import geocentral.ui.views.View;
import geocentral.ui.views.ViewActionArgs;
import geocentral.ui.views.ViewActionType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.json.JSONUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.DesktopUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.GenericCounter;
import org.bacza.utils.ObjectUtils;
import org.bacza.utils.ScreenCaptureUtils;
import org.bacza.utils.StringUtils;
import org.bacza.utils.ThreadUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.json.JSONObject;

public class Geocentral
extends ApplicationWindow {
    private static final Log log = LogFactory.getLog(Geocentral.class);
    private static final String FILE_NAME = "system-data.dat";
    private static final String SYS_MSG_VERSION = "version";
    private final Object selectingProfileLock = new Object();
    private boolean selectingProfile = false;
    private boolean activated = false;
    private boolean closing = false;
    private Object tabLock = new Object();
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget instanceof CTabItem) {
                Geocentral.this.tabDisposed(Geocentral.this.getTabInfo((CTabItem)e.widget));
            }
        }
    };
    private StatusLineManager statusLineManager;
    private CTabFolder tabFolder;
    private TabInfo currentTabInfo = null;
    private int documentNum = 0;
    private GenericCounter<String> documentCounter = new GenericCounter();
    private MenuManager windowMenuManager;
    private Action newFieldNotesAction;
    private Action openAction;
    private Action closeAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action importFieldNotesAction;
    private Action importGPXAction;
    private Action loginGcAction;
    private Action loginOcAction;
    private Action loginOpAction;
    private Action changeProfileAction;
    private Action exitAction;
    private Action editCutAction;
    private Action editCopyAction;
    private Action editPasteAction;
    private Action editSelectAllAction;
    private Action editDeleteAction;
    private Action editPreferences;
    private Action viewSimpleAction;
    private Action helpVisitHomepageAction;
    private Action helpVisitFanpageAction;
    private Action helpChangeLanguageAction;
    private Action helpAboutAction;

    public Geocentral() {
        super(null);
        DocumentService.getInstance().register(new FieldNotesProvider());
        this.createActions();
        this.addMenuBar();
        this.addStatusLine();
        UserProfileService.getInstance().addListener(new UserProfileListener(){

            @Override
            public void currentUser(UserProfile profile) {
                this.setTitle(Geocentral.this.getShellTitle(profile));
            }

            @Override
            public void userLogin(final UserProfile profile) {
                this.setTitle(Geocentral.this.getShellTitle(profile));
                ThreadUtils.exec(new Runnable(){

                    @Override
                    public void run() {
                        Geocentral.this.onUserLogin(profile);
                    }
                });
            }

            @Override
            public void userLogout(UserProfile profile) {
                this.setTitle(Geocentral.this.getShellTitle(null));
                Geocentral.this.selectProfile();
            }

            @Override
            public void siteAdded(UserProfile userProfile, SiteProfile siteProfile) {
                this.setTitle(Geocentral.this.getShellTitle(userProfile));
            }

            @Override
            public void siteRemoved(UserProfile userProfile, SiteProfile siteProfile) {
                this.setTitle(Geocentral.this.getShellTitle(userProfile));
            }

            private void setTitle(final String title) {
                DisplayUtils.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Geocentral.this.getShell();
                        if (shell != null && !shell.isDisposed()) {
                            shell.setText(title);
                        }
                    }
                });
            }
        });
        LanguageService.getInstance().addListener(new LanguageListener(){

            @Override
            public void languageChanged(String tag) {
                Geocentral.this.needRestart();
            }
        });
        WebConnectService.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String type = event.getPropertyName();
                if (StringUtils.equals(type, Geocentral.SYS_MSG_VERSION)) {
                    Geocentral.this.checkVersion();
                }
            }
        });
    }

    protected String getShellTitle(UserProfile profile) {
        String title = String.format("<%s>", Messages.getString("Geocentral.notLoggedIn"));
        if (profile != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(profile.getName());
            for (SiteProfile siteProfile : profile.getSiteProfiles()) {
                sb.append(String.format(" [%s: %s]", siteProfile.getSite().name(), siteProfile.getLogin()));
            }
            title = sb.toString();
        }
        return String.format("%s - %s", "GeoCentral Lite", title);
    }

    protected void configureShell(final Shell newShell) {
        super.configureShell(newShell);
        GlobalUtils.getInstance().setData("geocentral.main.shell", newShell);
        newShell.setText(this.getShellTitle(null));
        String bounds = ConfigManager.getInstance().getString("geocentral.main.ui.bounds");
        Rectangle rect = SWTUtils.stringToRect(bounds);
        if (rect != null) {
            newShell.setBounds(rect);
        } else {
            Rectangle screen = Display.getCurrent().getPrimaryMonitor().getBounds();
            newShell.setSize((int)((double)screen.width * 0.8), (int)((double)screen.height * 0.8));
            newShell.setMinimumSize(newShell.getSize().x / 2, newShell.getSize().y / 2);
            newShell.setLocation((screen.width - newShell.getBounds().width) / 2, (screen.height - newShell.getBounds().height) / 2);
        }
        boolean maximized = ConfigManager.getInstance().getBoolean("geocentral.main.ui.maximized", false);
        newShell.setMaximized(maximized);
        Image icon2 = SWTResourceManager.getImage(AboutDialog.class, "/images/logo_64.png");
        newShell.setImage(icon2);
        this.addDragAndDrop(newShell);
        DisplayUtils.getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 127 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    Control c = Display.getDefault().getFocusControl();
                    if (c instanceof Text || c instanceof StyledText || c instanceof Combo) {
                        return;
                    }
                    e.doit = false;
                    Geocentral.this.onDelete();
                    return;
                }
                if ((e.stateMask & SWT.MOD1) != 0 && e.keyCode == 0x1000015) {
                    e.doit = false;
                    Geocentral.this.onScreenshot();
                    return;
                }
                if (e.keyCode == 97 && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & SWT.MOD3) == 0) {
                    e.doit = false;
                    Geocentral.this.onSelectAll();
                    return;
                }
            }
        });
        newShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = Geocentral.this.closeDocuments();
                if (event.doit) {
                    boolean maximized = newShell.getMaximized();
                    ConfigManager.getInstance().setBoolean("geocentral.main.ui.maximized", maximized);
                }
            }
        });
        Listener boundsListener = new Listener(){

            public void handleEvent(Event e) {
                boolean normalState;
                boolean bl = normalState = !newShell.getMaximized() && !newShell.getMinimized();
                if (normalState) {
                    Rectangle r = newShell.getBounds();
                    ConfigManager.getInstance().setString("geocentral.main.ui.bounds", SWTUtils.rectToString(r));
                }
            }
        };
        newShell.addListener(11, boundsListener);
        newShell.addListener(10, boundsListener);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellevent) {
                Geocentral.this.appWindowActivated(!Geocentral.this.activated);
                Geocentral.this.activated = true;
            }
        });
    }

    protected void needRestart() {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DialogUtils.showConfirm(Messages.getString("Geocentral.restartMessage"))) {
                    Geocentral.this.onExit();
                }
            }
        });
    }

    protected boolean onExit() {
        if (this.closeDocuments()) {
            this.close();
            return true;
        }
        return false;
    }

    protected boolean closeDocuments() {
        try {
            this.closing = true;
            boolean bl = this.closeTabs();
            return bl;
        }
        finally {
            this.closing = false;
            this.initWindowMenuManager();
        }
    }

    protected boolean closeTabs() {
        boolean doit = true;
        try {
            this.activateTab(this.getTabInfo(0));
            while (doit && this.getTabCount() > 0) {
                doit = this.closeTab(this.getCurrentTabInfo(), true);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error closing documents", (Throwable)e);
            doit = false;
        }
        return doit;
    }

    private IConfigData getConfigData() {
        return ConfigDataService.getInstance().getSystemData(FILE_NAME, true);
    }

    private void checkVersion() {
        JSONObject msg = WebConnectService.getInstance().getSystemMessage(SYS_MSG_VERSION);
        if (msg != null) {
            final String date = msg.optString("date", null);
            final String version = msg.optString(SYS_MSG_VERSION, null);
            String url = "https://www.geocentral.pl";
            if (StringUtils.notEmpty(date, version, "https://www.geocentral.pl")) {
                long verLocal = VersionUtils.parse("1.0.16");
                long verAvail = VersionUtils.parse(version);
                if (verAvail > verLocal) {
                    DisplayUtils.asyncExecWithDelay(1000L, new Runnable(){

                        @Override
                        public void run() {
                            Geocentral.this.checkVersionNotify(date, version, "https://www.geocentral.pl");
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersionNotify(String date, String version, String url) {
        IConfigData data;
        if (this.isSelectingProfile()) {
            return;
        }
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        if (UserProfileService.getInstance().isDefaultProfile(profile)) {
            return;
        }
        boolean notify = false;
        IConfigData iConfigData = data = this.getConfigData();
        synchronized (iConfigData) {
            JSONObject root = data.getObject(profile.getUUID());
            JSONObject noti = JSONUtils.getObject(root, "notifications");
            JSONObject ver = noti.optJSONObject(SYS_MSG_VERSION);
            if (ver == null) {
                ver = JSONUtils.createObject(noti, SYS_MSG_VERSION);
                notify = true;
            } else {
                long verOld;
                long verNew = VersionUtils.parse(version);
                if (verNew > (verOld = VersionUtils.parse(ver.optString(SYS_MSG_VERSION, null)))) {
                    notify = true;
                } else {
                    Date ts = DateUtils.parseDateIso8601(ver.optString("ts", null));
                    double diffDays = DateUtils.getDaysBetween(DateUtils.truncate(ts), DateUtils.truncate(new Date()));
                    if (diffDays >= 1.0) {
                        notify = true;
                    }
                }
            }
            if (notify) {
                ver.put("released", (Object)date);
                ver.put(SYS_MSG_VERSION, (Object)version);
                ver.put("ts", (Object)DateUtils.formatDateGMT(new Date()));
                data.save();
            }
        }
        if (notify) {
            NewVersionDialog dialog = new NewVersionDialog(this.getShell(), date, version, url);
            dialog.open();
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    protected void addDragAndDrop(Shell shell) {
        DropTarget droptarget = new DropTarget((Control)shell, 23);
        FileTransfer fileTransfer = FileTransfer.getInstance();
        TextTransfer textTransfer = TextTransfer.getInstance();
        droptarget.setTransfer(new Transfer[]{textTransfer, fileTransfer});
        droptarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void dragOperationChanged(DropTargetEvent e) {
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void drop(DropTargetEvent e) {
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(e.currentDataType) && e.data != null) {
                    Geocentral.this.onDrop((String[])e.data);
                }
            }
        });
    }

    private void onDrop(String[] files) {
        DataModel<?> model = this.getCurrentDataModel();
        if (model instanceof FieldNoteDataModel && DialogUtils.showConfirm(Messages.getString("Geocentral.confirmImportFileAsFieldNotes"))) {
            EventList items = ((FieldNoteDataModel)model).getList();
            if (items.size() > 0 && !DialogUtils.showConfirm(Messages.getString("Geocentral.confirmFieldNotesDiscard"))) {
                return;
            }
            FieldNoteImportUtils.importFieldNotes(items, files);
        }
    }

    protected Control createContents(Composite parent) {
        Display display = this.getShell().getDisplay();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(container, 0x800000);
        this.tabFolder.setSimple(false);
        this.tabFolder.setBorderVisible(false);
        this.tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(35), display.getSystemColor(31)}, new int[]{100}, true);
        this.tabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                Geocentral.this.tabSelected(Geocentral.this.tabFolder.getSelectionIndex());
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Geocentral.this.tabSelected(Geocentral.this.tabFolder.getSelectionIndex());
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent e) {
                if (e.item instanceof CTabItem) {
                    e.doit = Geocentral.this.closeTab(Geocentral.this.getTabInfo((CTabItem)e.item), false);
                }
            }
        });
        return container;
    }

    public String createView(String docTypeId, boolean activate) {
        AssertUtils.notNull(docTypeId, "Document Type ID");
        IDocumentProvider provider = DocumentService.getInstance().getProvider(docTypeId);
        if (provider != null) {
            String docTypeName = StringUtils.nvl(provider.getDocTypeName(), Messages.getString("Geocentral.defaultDocTypeName"));
            View view = provider.createView();
            if (view != null) {
                DataModel<?> model = view.getDataModel();
                AssertUtils.notNull(model, "Data Model");
                final TabInfo info = new TabInfo();
                info.view = view;
                info.menu = view.getMenuManager();
                CTabItem tabItem = new CTabItem(this.tabFolder, 0);
                tabItem.setData((Object)info);
                tabItem.setControl(view.createControl(tabItem));
                tabItem.setShowClose(true);
                tabItem.addDisposeListener(this.disposeListener);
                if (model instanceof IChangeEventSource) {
                    ((IChangeEventSource)((Object)model)).addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(final PropertyChangeEvent e) {
                            DisplayUtils.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Geocentral.this.dataModelChanged(e, info);
                                }
                            });
                        }
                    });
                }
                info.tabItem = tabItem;
                info.docTypeId = docTypeId;
                info.docTypeName = docTypeName;
                info.docTypeNum = this.documentCounter.increment(docTypeId);
                info.docNum = ++this.documentNum;
                info.docId = String.format("document%d", info.docNum);
                info.initialTitle = String.format("%s %d", docTypeName, info.docTypeNum);
                info.updateTitle();
                DataModelService.getInstance().registerDataModel(info.docId, model);
                if (activate) {
                    this.activateTab(info);
                }
                this.initWindowMenuManager();
                Sysmon.instance.postEvent(Sysmon.EventType.DOCUMENT_NEW);
                return info.docId;
            }
        }
        return null;
    }

    protected void appWindowActivated(boolean firstTime) {
        if (firstTime) {
            ThreadUtils.exec(new Runnable(){

                @Override
                public void run() {
                    ThreadUtils.sleep(100L);
                    Geocentral.this.selectProfile();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectingProfile(boolean selectingProfile) {
        Object object = this.selectingProfileLock;
        synchronized (object) {
            this.selectingProfile = selectingProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSelectingProfile() {
        Object object = this.selectingProfileLock;
        synchronized (object) {
            return this.selectingProfile;
        }
    }

    protected void selectProfile() {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                Geocentral.this.setSelectingProfile(true);
                Geocentral.this.onSelectProfile();
                Geocentral.this.setSelectingProfile(false);
            }
        });
    }

    protected void onUserLogin(UserProfile profile) {
        this.checkVersion();
    }

    protected void dataModelChanged(PropertyChangeEvent e, TabInfo info) {
        if ("filename".equals(e.getPropertyName())) {
            info.setFilename((String)e.getNewValue());
            this.initWindowMenuManager();
        } else if ("dirty".equals(e.getPropertyName())) {
            info.setDirty((Boolean)e.getNewValue());
            this.initWindowMenuManager();
        }
    }

    protected boolean closeTab(TabInfo info, boolean dispose) {
        boolean doit = true;
        if (info == null) {
            return doit;
        }
        ViewActionArgs args = new ViewActionArgs(ViewActionType.TRY_CLOSE, info.title);
        info.view.onAction(args);
        doit = args.doit;
        if (doit) {
            info.tabClosed();
            DataModelService.getInstance().unregisterDataModel(info.docId);
            if (dispose) {
                info.tabItem.dispose();
            }
        }
        return doit;
    }

    protected void tabDisposed(TabInfo info) {
        this.initWindowMenuManager();
    }

    protected void activateTab(TabInfo info) {
        if (info != null && info.tabItem != null) {
            this.tabFolder.setSelection(info.tabItem);
            this.tabSelected(this.tabFolder.getSelectionIndex());
        }
    }

    protected int getTabCount() {
        return this.tabFolder.getItemCount();
    }

    protected TabInfo getCurrentTabInfo() {
        return this.getTabInfo(this.tabFolder.getSelection());
    }

    protected TabInfo getTabInfo(int index) {
        if (index >= 0 && index < this.tabFolder.getItemCount()) {
            return this.getTabInfo(this.tabFolder.getItem(index));
        }
        return null;
    }

    protected TabInfo getTabInfo(CTabItem item) {
        Object data;
        if (item != null && (data = item.getData()) instanceof TabInfo) {
            return (TabInfo)data;
        }
        return null;
    }

    protected DataModel<?> getCurrentDataModel() {
        TabInfo info = this.getCurrentTabInfo();
        if (info != null && info.docId != null) {
            return DataModelService.getInstance().getDataModel(info.docId);
        }
        return null;
    }

    private void tabSelected(int index) {
        TabInfo info = this.getTabInfo(index);
        if (info != null) {
            info.setFocus();
        }
        if (ObjectUtils.equals(info, this.currentTabInfo)) {
            return;
        }
        if (this.currentTabInfo != null) {
            this.currentTabInfo.tabDeactivated();
        }
        if (info != null) {
            info.tabActivated();
        }
        View view = info != null ? info.view : null;
        this.initMenu(info, this.currentTabInfo);
        this.initStatusLine(this.statusLineManager, view);
        this.currentTabInfo = info;
    }

    private void initMenu(TabInfo info, TabInfo prev) {
        MenuManager mainMenu = this.getMenuBarManager();
        if (mainMenu != null) {
            MenuManager menuPrev;
            MenuManager menu = info != null ? info.menu : null;
            MenuManager menuManager = menuPrev = prev != null ? prev.menu : null;
            if (!ObjectUtils.equals(menu, menuPrev)) {
                if (menuPrev != null) {
                    mainMenu.remove((IContributionItem)menuPrev);
                }
                if (menu != null) {
                    mainMenu.appendToGroup("geocentral.menu.addons.group1", (IContributionItem)menu);
                }
                mainMenu.update(true);
            }
        }
    }

    private void initStatusLine(StatusLineManager manager, View view) {
        manager.removeAll();
        manager.add((IContributionItem)new GroupMarker("BEGIN_GROUP"));
        manager.add((IContributionItem)new GroupMarker("MIDDLE_GROUP"));
        manager.add((IContributionItem)new GroupMarker("END_GROUP"));
        if (view != null) {
            view.addStatusLineContributions(manager);
        }
        manager.update(false);
    }

    private ImageDescriptor createImageDescriptor(String filename) {
        return ImageDescriptor.createFromFile(Geocentral.class, (String)filename);
    }

    private void createActions() {
        this.newFieldNotesAction = new Action(Messages.getString("Geocentral.action.fieldNotes")){

            public void run() {
                Geocentral.this.onNew("geocentral.document.field_notes");
            }
        };
        this.newFieldNotesAction.setAccelerator(SWT.MOD1 + 78);
        this.openAction = new Action(Messages.getString("Geocentral.action.open")){

            public void run() {
                Geocentral.this.onOpen();
            }
        };
        this.openAction.setAccelerator(SWT.MOD1 + 79);
        this.closeAction = new Action(Messages.getString("Geocentral.action.close")){

            public void run() {
                Geocentral.this.closeTab(Geocentral.this.getCurrentTabInfo(), true);
            }
        };
        this.closeAction.setAccelerator(SWT.MOD1 + 87);
        this.saveAction = new Action(Messages.getString("Geocentral.action.save"), this.createImageDescriptor("/icons/save_edit.gif")){

            public void run() {
                Geocentral.this.onSave();
            }
        };
        this.saveAction.setAccelerator(SWT.MOD1 + 83);
        this.saveAsAction = new Action(Messages.getString("Geocentral.action.saveAs"), this.createImageDescriptor("/icons/saveas_edit.gif")){

            public void run() {
                Geocentral.this.onSaveAs();
            }
        };
        this.saveAsAction.setAccelerator(SWT.MOD1 + SWT.MOD2 + 83);
        this.loginGcAction = new Action(GeocacheSite.GC.getSiteName()){

            public void run() {
                Geocentral.this.onLoginSite(GeocacheSite.GC);
            }
        };
        this.loginOcAction = new Action(GeocacheSite.OC.getSiteName()){

            public void run() {
                Geocentral.this.onLoginSite(GeocacheSite.OC);
            }
        };
        this.loginOpAction = new Action(GeocacheSite.OP.getSiteName()){

            public void run() {
                Geocentral.this.onLoginSite(GeocacheSite.OP);
            }
        };
        this.changeProfileAction = new Action(Messages.getString("Geocentral.action.changeProfile")){

            public void run() {
                Geocentral.this.onChangeProfile();
            }
        };
        this.importFieldNotesAction = new Action(Messages.getString("Geocentral.action.importFileAsFieldNotes")){

            public void run() {
                Geocentral.this.onImportFieldNotes();
            }
        };
        this.importFieldNotesAction.setAccelerator(SWT.MOD1 | SWT.MOD2 + 78);
        this.importGPXAction = new Action(Messages.getString("Geocentral.action.importGpxAsFieldNotes")){

            public void run() {
                Geocentral.this.onImportGPX();
            }
        };
        this.exitAction = new Action(Messages.getString("Geocentral.action.exit")){

            public void run() {
                Geocentral.this.onExit();
            }
        };
        this.editCutAction = new Action(Messages.getString("Geocentral.action.editCut"), this.createImageDescriptor("/icons/cut_edit.gif")){

            public void run() {
                Geocentral.this.onCut();
            }
        };
        this.editCutAction.setAccelerator(SWT.MOD1 + 88);
        this.editCopyAction = new Action(Messages.getString("Geocentral.action.editCopy"), this.createImageDescriptor("/icons/copy_edit.gif")){

            public void run() {
                Geocentral.this.onCopy();
            }
        };
        this.editCopyAction.setAccelerator(SWT.MOD1 + 67);
        this.editPasteAction = new Action(Messages.getString("Geocentral.action.editPaste"), this.createImageDescriptor("/icons/paste_edit.gif")){

            public void run() {
                Geocentral.this.onPaste();
            }
        };
        this.editPasteAction.setAccelerator(SWT.MOD1 + 86);
        this.editSelectAllAction = new Action(Messages.getString("Geocentral.action.editSelectAll")){

            public void run() {
                Geocentral.this.onSelectAll();
            }
        };
        this.editSelectAllAction.setAccelerator(SWT.MOD1 + 65);
        this.editDeleteAction = new Action(Messages.getString("Geocentral.action.editDelete"), this.createImageDescriptor("/icons/delete_edit.gif")){

            public void run() {
                Geocentral.this.onDelete();
            }
        };
        this.editPreferences = new Action(Messages.getString("Geocentral.action.editPreferences")){

            public void run() {
                Preferences p = new Preferences();
                p.show(Geocentral.this.getShell());
            }
        };
        this.viewSimpleAction = new Action(Messages.getString("Geocentral.action.viewSimple")){};
        this.helpVisitHomepageAction = new Action(Messages.getString("Geocentral.action.helpVisitHomepage")){

            public void run() {
                DesktopUtils.openUrl("https://www.geocentral.pl");
            }
        };
        this.helpVisitFanpageAction = new Action(Messages.getString("Geocentral.action.helpVisitFanpage"), this.createImageDescriptor("/images/facebook_16.png")){

            public void run() {
                DesktopUtils.openUrl("https://www.facebook.com/GeoCentralPL");
            }
        };
        this.helpChangeLanguageAction = new Action(Messages.getString("Geocentral.action.helpLanguage")){

            public void run() {
                Geocentral.this.onHelpChangeLanguage();
            }
        };
        this.helpAboutAction = new Action(Messages.getString("Geocentral.action.helpAbout")){

            public void run() {
                Geocentral.this.onHelpAbout();
            }
        };
    }

    protected MenuManager createMenuManager() {
        MenuManager menu = new MenuManager("menu", "geocentral.menu");
        MenuManager file = new MenuManager(Messages.getString("Geocentral.action.file"), "geocentral.menu.file");
        menu.add((IContributionItem)file);
        MenuManager fileNew = new MenuManager(Messages.getString("Geocentral.action.fileNew"));
        fileNew.add((IAction)this.newFieldNotesAction);
        file.add((IContributionItem)fileNew);
        file.add((IAction)this.openAction);
        file.add((IContributionItem)new Separator());
        file.add((IAction)this.closeAction);
        file.add((IContributionItem)new Separator());
        file.add((IAction)this.saveAction);
        file.add((IAction)this.saveAsAction);
        file.add((IContributionItem)new Separator());
        MenuManager fileImport = new MenuManager(Messages.getString("Geocentral.action.fileImport"));
        fileImport.add((IAction)this.importFieldNotesAction);
        fileImport.add((IAction)this.importGPXAction);
        file.add((IContributionItem)fileImport);
        file.add((IContributionItem)new Separator());
        MenuManager fileLogin = new MenuManager(Messages.getString("Geocentral.action.fileLogin"));
        fileLogin.add((IAction)this.loginGcAction);
        fileLogin.add((IAction)this.loginOpAction);
        fileLogin.add((IAction)this.loginOcAction);
        file.add((IContributionItem)fileLogin);
        file.add((IAction)this.changeProfileAction);
        file.add((IContributionItem)new Separator());
        file.add((IAction)this.exitAction);
        MenuManager edit = new MenuManager(Messages.getString("Geocentral.action.edit"), "geocentral.menu.edit");
        menu.add((IContributionItem)edit);
        edit.add((IAction)this.editCutAction);
        edit.add((IAction)this.editCopyAction);
        edit.add((IAction)this.editPasteAction);
        edit.add((IAction)this.editDeleteAction);
        edit.add((IContributionItem)new Separator());
        edit.add((IAction)this.editSelectAllAction);
        edit.add((IContributionItem)new Separator());
        edit.add((IAction)this.editPreferences);
        MenuManager view = new MenuManager(Messages.getString("Geocentral.action.view"), "geocentral.menu.view");
        menu.add((IContributionItem)view);
        view.setRemoveAllWhenShown(true);
        view.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                Geocentral.this.menuViewInit(menu);
            }
        });
        menu.add((IContributionItem)new GroupMarker("geocentral.menu.addons.group1"));
        menu.add((IContributionItem)new GroupMarker("geocentral.menu.addons.group2"));
        menu.add((IContributionItem)new GroupMarker("geocentral.menu.addons.group3"));
        this.windowMenuManager = new MenuManager(Messages.getString("Geocentral.action.window"), "geocentral.menu.window");
        menu.add((IContributionItem)this.windowMenuManager);
        MenuManager help = new MenuManager(Messages.getString("Geocentral.action.help"), "geocentral.menu.help");
        menu.add((IContributionItem)help);
        help.add((IAction)this.helpVisitHomepageAction);
        help.add((IAction)this.helpVisitFanpageAction);
        help.add((IContributionItem)new Separator());
        help.add((IAction)this.helpChangeLanguageAction);
        help.add((IContributionItem)new Separator());
        help.add((IAction)this.helpAboutAction);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TabInfo[] getAllTabInfo() {
        Object object = this.tabLock;
        synchronized (object) {
            int count = this.tabFolder != null ? this.tabFolder.getItemCount() : 0;
            count = Math.max(count, 0);
            TabInfo[] infos = new TabInfo[count];
            int i = 0;
            while (i < count) {
                infos[i] = this.getTabInfo(i);
                ++i;
            }
            return infos;
        }
    }

    protected void menuViewInit(IMenuManager menu) {
        TabInfo info = this.getCurrentTabInfo();
        if (info == null) {
            this.viewSimpleAction.setEnabled(false);
            menu.add((IAction)this.viewSimpleAction);
            return;
        }
        if (info.view instanceof IMenuItemProvider) {
            ((IMenuItemProvider)((Object)info.view)).initMenuManager(menu);
            return;
        }
        this.viewSimpleAction.setEnabled(true);
        menu.add((IAction)this.viewSimpleAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWindowMenuManager() {
        if (!this.closing && this.windowMenuManager != null) {
            this.windowMenuManager.removeAll();
            Object object = this.tabLock;
            synchronized (object) {
                TabInfo[] infos = this.getAllTabInfo();
                int count = Math.min(infos.length, 9);
                int i = 0;
                while (i < count) {
                    TabInfo info = infos[i];
                    final int ii = i;
                    int index = i + 1;
                    Action action = new Action(){

                        public void run() {
                            Geocentral.this.onActivate(ii);
                        }
                    };
                    String text = String.format("&%d: %s", index, info.title);
                    action.setText(StringUtils.nvl(text, Messages.getString("Geocentral.action.windowListItemDefaultName")));
                    action.setAccelerator(SWT.MOD3 + 48 + index);
                    this.windowMenuManager.add((IAction)action);
                    ++i;
                }
            }
            this.windowMenuManager.getParent().update(true);
            this.windowMenuManager.update(true);
        }
    }

    protected ToolBarManager createToolBarManager(int style) {
        return null;
    }

    protected StatusLineManager createStatusLineManager() {
        this.statusLineManager = new StatusLineManager();
        this.initStatusLine(this.statusLineManager, null);
        GlobalUtils.getInstance().setData("geocentral.main.status", this.statusLineManager);
        return this.statusLineManager;
    }

    protected void onSelectProfile() {
        while (true) {
            try {
                do {
                    SelectProfileDialog dialog;
                    if ((dialog = new SelectProfileDialog(this.getShell())).open() != 0) continue;
                    if (this.getTabCount() == 0) {
                        this.createView("geocentral.document.field_notes", true);
                    }
                    return;
                } while (!this.onExit());
                return;
            }
            catch (Exception e) {
                log.debug((Object)"Error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected void onNew(String docId) {
        this.createView(docId, true);
    }

    protected void onOpen() {
        String[] filenames = FileDialogUtils.getFilenamesToOpen();
        if (filenames != null) {
            this.onOpenFiles(filenames);
        }
    }

    protected void onOpenFiles(String[] filenames) {
        AssertUtils.notNull(filenames, "File Names");
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            TabInfo info;
            String filename = stringArray[n2];
            String docId = this.createView("geocentral.document.field_notes", true);
            if (docId != null && (info = this.getCurrentTabInfo()) != null && info.view != null) {
                info.view.onAction(new ViewActionArgs(ViewActionType.OPEN, filename));
            }
            ++n2;
        }
    }

    protected void onSave() {
        TabInfo info = this.getCurrentTabInfo();
        if (info != null) {
            String filename = info.filename;
            if (filename != null) {
                info.view.onAction(new ViewActionArgs(ViewActionType.SAVE, filename));
            } else {
                this.onSaveAs();
            }
        }
    }

    protected void onSaveAs() {
        String filename;
        TabInfo info = this.getCurrentTabInfo();
        if (info != null && (filename = FileDialogUtils.getFilenameToSave()) != null) {
            info.view.onAction(new ViewActionArgs(ViewActionType.SAVE, filename));
        }
    }

    protected void onLoginSite(GeocacheSite site) {
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        SiteLoginAction action = new SiteLoginAction(profile, site);
        SiteLoginDialog dialog = GeocacheSite.GC.equals((Object)site) ? new PasswordLoginDialog(this.getShell(), site, action) : new OAuthLoginDialog(this.getShell(), site, action);
        if (dialog.open() == 0 && action.isLoginOk()) {
            MessageUtils.showLoginOK();
        }
    }

    protected void onChangeProfile() {
        if (this.closeDocuments()) {
            UserProfileService.getInstance().logout();
        }
    }

    protected void onLogoutGc() {
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        LogoutAction action = new LogoutAction(profile, GeocacheSite.GC);
        PluginExecutor.getInstance().executeSync(action);
    }

    protected void onImportFieldNotes() {
        TabInfo info = this.getCurrentTabInfo();
        if (info == null) {
            return;
        }
        if (info.docId == null) {
            return;
        }
        DataModel<?> model = DataModelService.getInstance().getDataModel(info.docId);
        AssertUtils.notNull(model, "Data Model");
        if (model instanceof FieldNoteDataModel) {
            EventList items = ((FieldNoteDataModel)model).getList();
            if (items.size() > 0 && !DialogUtils.showConfirm(Messages.getString("Geocentral.confirmFieldNotesDiscard"))) {
                return;
            }
            String[] filterNames = new String[]{"Text Files (*.txt)", "All Files (*.*)"};
            String[] filterExts = new String[]{".txt", ".*"};
            String[] filenames = FileDialogUtils.getFiles(this.getShell(), 4098, filterNames, filterExts, null);
            if (filenames != null) {
                FieldNoteImportUtils.importFieldNotes(items, filenames);
            }
        }
    }

    protected void onImportGPX() {
        TabInfo info = this.getCurrentTabInfo();
        if (info == null) {
            return;
        }
        if (info.docId == null) {
            return;
        }
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        DataModel<?> model = DataModelService.getInstance().getDataModel(info.docId);
        AssertUtils.notNull(model, "Data Model");
        if (model instanceof FieldNoteDataModel) {
            EventList items = ((FieldNoteDataModel)model).getList();
            if (items.size() > 0 && !DialogUtils.showConfirm(Messages.getString("Geocentral.confirmFieldNotesDiscard"))) {
                return;
            }
            String[] filterNames = new String[]{"GPX Files (*.gpx)", "All Files (*.*)"};
            String[] filterExts = new String[]{".gpx", ".*"};
            String[] filenames = FileDialogUtils.getFiles(this.getShell(), 4098, filterNames, filterExts, null);
            if (filenames != null) {
                FieldNoteImportUtils.importGPX(profile, items, filenames);
            }
        }
    }

    protected void onActivate(int index) {
        this.activateTab(this.getTabInfo(index));
    }

    protected void onSelectAll() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl instanceof Text) {
            ((Text)ctrl).selectAll();
        } else if (ctrl instanceof StyledText) {
            ((StyledText)ctrl).selectAll();
        } else if (ctrl instanceof Table) {
            ((Table)ctrl).selectAll();
            ctrl.notifyListeners(13, null);
        }
    }

    protected void onCut() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl instanceof Text) {
            ((Text)ctrl).cut();
        } else if (ctrl instanceof StyledText) {
            ((StyledText)ctrl).cut();
        } else {
            TabInfo info = this.getCurrentTabInfo();
            if (info != null && info.view != null) {
                info.view.onCut();
            }
        }
    }

    protected void onCopy() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl instanceof Text) {
            ((Text)ctrl).copy();
        } else if (ctrl instanceof StyledText) {
            ((StyledText)ctrl).copy();
        } else {
            TabInfo info = this.getCurrentTabInfo();
            if (info != null && info.view != null) {
                info.view.onCopy();
            }
        }
    }

    protected void onPaste() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl instanceof Text) {
            ((Text)ctrl).paste();
        } else if (ctrl instanceof StyledText) {
            ((StyledText)ctrl).paste();
        } else {
            TabInfo info = this.getCurrentTabInfo();
            if (info != null && info.view != null) {
                info.view.onPaste();
            }
        }
    }

    protected void onDelete() {
        TabInfo info = this.getCurrentTabInfo();
        if (info != null && info.view != null) {
            info.view.onDelete();
        }
    }

    protected void onScreenshot() {
        try {
            String filename = String.format("geocentral-%s.png", DateUtils.getCurrentTimestamp());
            ScreenCaptureUtils.captureImageToFile(this.getShell(), filename);
            DialogUtils.showInfo(Messages.getString("Geocentral.screenshotDone"));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageUtils.showException(e);
        }
    }

    protected void onToolsScriptingReload() {
        ScriptingManager.getInstance().reloadAll();
    }

    protected void onHelpChangeLanguage() {
        LanguageDialog dlg = new LanguageDialog(this.getShell());
        if (dlg.open() == 0) {
            LanguageService.getInstance().setLanguage(dlg.getLang());
        }
    }

    protected void onHelpAbout() {
        AboutDialog dlg = new AboutDialog(this.getShell());
        dlg.open();
    }

    class TabInfo {
        TabState state = TabState.CREATED;
        View view = null;
        MenuManager menu = null;
        CTabItem tabItem = null;
        String docTypeId = null;
        String docTypeName = null;
        int docTypeNum = 0;
        int docNum = 0;
        String docId = null;
        String title = null;
        String initialTitle = null;
        String filename = null;
        boolean dirty = false;

        TabInfo() {
        }

        void setFocus() {
            this.view.setFocus();
        }

        void tabActivated() {
            if (this.state == TabState.CREATED || this.state == TabState.DEACTIVATED) {
                this.view.activated();
                this.state = TabState.ACTIVATED;
            }
        }

        void tabDeactivated() {
            if (this.state == TabState.ACTIVATED) {
                this.view.deactivated();
                this.state = TabState.DEACTIVATED;
            }
        }

        void tabClosed() {
            this.tabDeactivated();
            if (this.state != TabState.CLOSED) {
                this.view.closed();
                this.state = TabState.CLOSED;
            }
        }

        void setFilename(String filename) {
            this.filename = filename;
            this.updateTitle();
        }

        void setDirty(boolean dirty) {
            this.dirty = dirty;
            this.updateTitle();
        }

        void updateTitle() {
            if (this.state != TabState.CLOSED) {
                String file = FileUtils.getFilename(this.filename);
                this.title = StringUtils.nvl(file, this.initialTitle);
                this.tabItem.setText(String.format("%s%s", this.dirty ? "*" : "", this.title));
                this.tabItem.setToolTipText(this.docTypeName);
            }
        }
    }

    static enum TabState {
        CREATED,
        ACTIVATED,
        DEACTIVATED,
        CLOSED;

    }
}

