/*
 * Decompiled with CFR 0.152.
 */
package geocentral.app;

import geocentral.common.GlobalUtils;
import geocentral.common.Messages;
import geocentral.common.app.UserProfileService;
import geocentral.common.ui.DialogUtils;
import org.bacza.http.URLUtils;
import org.bacza.utils.DesktopUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AboutDialog
extends Dialog {
    private int clickCount = 0;
    private static final int CLICK_MAX = 5;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("AboutDialog.title"));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 24;
        gridLayout.numColumns = 2;
        container.setBackground(SWTResourceManager.getColor(1));
        Label logo = new Label(container, 0);
        logo.setBackground(SWTResourceManager.getColor(1));
        logo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (AboutDialog.this.clickCount < 5) {
                    AboutDialog aboutDialog = AboutDialog.this;
                    aboutDialog.clickCount = aboutDialog.clickCount + 1;
                    if (AboutDialog.this.clickCount >= 5) {
                        GlobalUtils.getInstance().setData("geocentral.config.advanced", 1);
                        DialogUtils.showInfo(Messages.getString("AboutDialog.advancedConfigUnlocked"));
                    }
                }
            }
        });
        logo.setImage(SWTResourceManager.getImage(AboutDialog.class, "/images/logo_64.png"));
        StyledText styledText = new StyledText(container, 8);
        styledText.setBackground(SWTResourceManager.getColor(1));
        this.initText(styledText);
        styledText.setEnabled(false);
        new Label(container, 0);
        Composite composite = new Composite(container, 0);
        composite.setBackground(SWTResourceManager.getColor(1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginBottom = 5;
        gl_composite.marginTop = 2;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 2;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Link linkHome = new Link(composite, 0);
        linkHome.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        linkHome.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DesktopUtils.openUrl("https://www.geocentral.pl");
            }
        });
        linkHome.setBackground(SWTResourceManager.getColor(1));
        linkHome.setText(String.format("<a>%s</a>", URLUtils.stripProtocol("https://www.geocentral.pl")));
        Link linkEmail = new Link(composite, 0);
        linkEmail.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        linkEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mailto = String.format("mailto:%s", "jbaczynski@gmail.com");
                DesktopUtils.openUrl(mailto);
            }
        });
        linkEmail.setBackground(SWTResourceManager.getColor(1));
        linkEmail.setText(String.format("<a>%s</a>", "jbaczynski@gmail.com"));
        new Label(container, 0);
        Label labelAppid = new Label(container, 0);
        labelAppid.setBackground(SWTResourceManager.getColor(1));
        labelAppid.setText(Messages.getString("AboutDialog.installationId"));
        new Label(container, 0);
        Text appid = new Text(container, 2048);
        appid.setEditable(false);
        appid.setText(UserProfileService.getInstance().getAppId());
        appid.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        return container;
    }

    protected void initText(StyledText styledText) {
        String text = String.format("%s%n%s %s%n%s", "GeoCentral Lite", Messages.getString("AboutDialog.version"), "1.0.16", "\u00a9 2015-2024 Jaros\u0142aw 'bacza' Baczy\u0144ski.");
        styledText.setText(text);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

