/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.opencaching.data.json;

import geocentral.api.opencaching.data.json.OkapiErrorResponse;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class OkapiErrorResponseParser {
    private static final String ERR_CLASS_BAD_REQUEST = "bad_request";
    private static final String ERR_CLASS_INVALID_OAUTH = "invalid_oauth_request";

    public static OkapiErrorResponse parse(String text) {
        AssertUtils.notEmpty(text, "JSON text");
        try {
            return OkapiErrorResponseParser.parse(new JSONObject(text));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static OkapiErrorResponse parse(JSONObject json) {
        AssertUtils.notNull(json, "JSON data");
        JSONObject error = json.optJSONObject("error");
        if (error == null) {
            return null;
        }
        OkapiErrorResponse resp = new OkapiErrorResponse();
        resp.setInternalStatus(error.optInt("status", 0));
        resp.setInternalMessage(error.optString("developer_message", null));
        resp.setParamName(error.optString("parameter", null));
        resp.setParamMessage(error.optString("whats_wrong_about_it", null));
        JSONArray array = error.optJSONArray("reason_stack");
        int i = 0;
        while (i < array.length()) {
            resp.addReason(array.optString(i, null));
            ++i;
        }
        if (resp.hasReason(ERR_CLASS_BAD_REQUEST)) {
            if (resp.hasReasons(ERR_CLASS_BAD_REQUEST, "invalid_parameter") && StringUtils.equals(resp.getParamName(), "cache_code") && StringUtils.contains(resp.getParamMessage(), "cache does not exist")) {
                resp.setMessage("Taki kesz nie istnieje.");
            }
        } else if (resp.hasReason(ERR_CLASS_INVALID_OAUTH)) {
            if (resp.hasReasons(ERR_CLASS_INVALID_OAUTH, "invalid_token")) {
                resp.setMessage("Nieprawid\u0142owy token.");
            } else if (resp.hasReasons(ERR_CLASS_INVALID_OAUTH, "invalid_timestamp")) {
                resp.setMessage("Nieprawid\u0142owy znacznik czasu.");
            }
        }
        return resp;
    }
}

