/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.opencaching;

import geocentral.api.opencaching.data.json.OkapiErrorResponse;
import geocentral.api.opencaching.data.json.OkapiErrorResponseParser;
import java.io.IOException;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.http.HttpResponseException;
import org.bacza.http.ResponseUtils;
import org.bacza.http.WebExecutor;

public class OkapiWebExecutor
extends WebExecutor {
    private static final Log log = LogFactory.getLog(OkapiWebExecutor.class);

    @Override
    protected void checkResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            if (ResponseUtils.isJsonResponse(response)) {
                String text = this.getContentText(response);
                OkapiErrorResponse err = OkapiErrorResponseParser.parse(text);
                if (err != null) {
                    throw new HttpResponseException(response, err.getMessage());
                }
                log.debug((Object)("Invalid error response: " + text));
                throw new HttpResponseException(response);
            }
            throw new HttpResponseException(response);
        }
    }

    protected String getContentText(Response response) {
        try {
            return ResponseUtils.getContentText(response);
        }
        catch (IOException e) {
            return null;
        }
    }
}

