/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.oauth;

import geocentral.app.Geocentral;
import org.bacza.http.URLUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class OAuthLoginWindow
extends ApplicationWindow {
    private Browser browser = null;
    private String url = null;
    private String requestUrl = null;
    private String callbackUrl = null;
    private boolean callbackFound = false;

    public OAuthLoginWindow(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.addStatusLine();
    }

    public String getUrl() {
        return this.url;
    }

    public String getVerifier() {
        return URLUtils.getParamValue(this.url, "oauth_verifier");
    }

    private void setUrl(String url) {
        this.url = url;
        if (url != null && url.startsWith(this.callbackUrl)) {
            this.callbackFound = true;
            this.close();
        }
    }

    private String createTitle(String text) {
        return StringUtils.nvl(text, "Logging in");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.createTitle(null));
        Image icon = SWTResourceManager.getImage(Geocentral.class, "/images/logo_64.png");
        shell.setImage(icon);
        Rectangle screen = Display.getCurrent().getPrimaryMonitor().getBounds();
        shell.setSize((int)((double)screen.width * 0.9), (int)((double)screen.height * 0.9));
        shell.setMinimumSize(shell.getSize().x / 2, shell.getSize().y / 2);
        shell.setLocation((screen.width - shell.getBounds().width) / 2, (screen.height - shell.getBounds().height) / 3);
    }

    protected Control createContents(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                OAuthLoginWindow.this.getShell().setText(OAuthLoginWindow.this.createTitle(event.title));
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                OAuthLoginWindow.this.setStatus(event.text);
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                OAuthLoginWindow.this.setUrl(event.location);
            }

            public void changed(LocationEvent event) {
                OAuthLoginWindow.this.setUrl(event.location);
            }
        });
        this.browser.setUrl(this.requestUrl);
        return this.browser;
    }

    public boolean getAuthorization(String requestUrl, String callbackUrl) {
        this.requestUrl = requestUrl;
        this.callbackUrl = callbackUrl;
        this.callbackFound = false;
        this.open();
        return this.callbackFound;
    }
}

