/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.oauth;

import geocentral.api.oauth.OAuthConfig;
import geocentral.api.oauth.OAuthConsumerException;
import geocentral.api.oauth.OAuthLoginWindow;
import geocentral.api.oauth.OkHttpOAuthProviderEx;
import geocentral.common.app.ConfigDataService;
import geocentral.common.app.IConfigData;
import geocentral.common.app.UserProfile;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.RunnableWithResult;
import geocentral.http.WebClientManager;
import java.io.IOException;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthException;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.json.JSONUtils;
import org.bacza.http.WebClient;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONObject;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;

public final class OAuthHelper {
    private static final Log log = LogFactory.getLog(OAuthHelper.class);
    private static final String FILE_NAME = "system-data-2.dat";
    private final OAuthConfig config;
    private final UserProfile profile;
    private final IConfigData data;
    private final String userKey;
    private final String siteKey;
    private OAuthConsumer consumer;

    public OAuthHelper(OAuthConfig config, UserProfile profile) {
        AssertUtils.notNull(config, "config");
        AssertUtils.notNull(profile, "profile");
        this.config = config;
        this.profile = profile;
        this.data = ConfigDataService.getInstance().getSystemData(FILE_NAME, true);
        this.userKey = profile.getUUID().toString();
        this.siteKey = config.site.toString();
        this.consumer = null;
        this.load();
    }

    public GeocacheSite getSite() {
        return this.config.site;
    }

    private OAuthConsumer createConsumer() {
        return new OkHttpOAuthConsumer(this.config.consumerKey, this.config.consumerSecret);
    }

    private OAuthProvider createProvider() {
        WebClient client = WebClientManager.getInstance().getClient(this.profile);
        OkHttpOAuthProviderEx provider = new OkHttpOAuthProviderEx(this.config.requestTokenUrl, this.config.accessTokenUrl, this.config.authorizationUrl, client.getHttpClient());
        provider.setOAuth10a(true);
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            JSONObject root = this.data.getObject(this.userKey);
            JSONObject site = root.optJSONObject(this.siteKey);
            if (site != null) {
                String token = site.optString("token", null);
                String secret = site.optString("secret", null);
                if (StringUtils.notEmpty(token, secret)) {
                    this.consumer = this.createConsumer();
                    this.consumer.setTokenWithSecret(token, secret);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            JSONObject root = this.data.getObject(this.userKey);
            if (this.consumer == null) {
                root.remove(this.siteKey);
            } else {
                JSONObject site = JSONUtils.createObject(root, this.siteKey);
                site.put("token", (Object)this.consumer.getToken());
                site.put("secret", (Object)this.consumer.getTokenSecret());
            }
            this.data.save();
        }
    }

    public synchronized boolean login() throws IOException, OAuthConsumerException {
        block8: {
            LoginResult result;
            OAuthConsumer consumer;
            OAuthProvider provider;
            block7: {
                this.consumer = null;
                provider = this.createProvider();
                consumer = this.createConsumer();
                final String authUrl = provider.retrieveRequestToken(consumer, this.config.callbackUrl, new String[0]);
                RunnableWithResult<LoginResult> runnable = new RunnableWithResult<LoginResult>(){

                    @Override
                    public void run() {
                        Shell shell = DisplayUtils.getShell();
                        OAuthLoginWindow auth = new OAuthLoginWindow(shell);
                        if (auth.getAuthorization(authUrl, ((OAuthHelper)OAuthHelper.this).config.callbackUrl)) {
                            this.setResult(new LoginResult(auth.getVerifier()));
                        } else {
                            this.setResult(null);
                        }
                    }
                };
                DisplayUtils.syncExec(runnable);
                result = (LoginResult)runnable.getResult();
                if (result != null) break block7;
                this.save();
                return false;
            }
            try {
                try {
                    if (result.verifier == null) break block8;
                    provider.retrieveAccessToken(consumer, result.verifier, new String[0]);
                    this.consumer = consumer;
                }
                catch (OAuthCommunicationException e) {
                    throw new IOException(e.getMessage());
                }
                catch (OAuthException e) {
                    log.debug((Object)"Error", (Throwable)e);
                    this.save();
                }
            }
            catch (Throwable throwable) {
                this.save();
                throw throwable;
            }
        }
        this.save();
        if (this.consumer == null) {
            throw new OAuthConsumerException("NO_CONSUMER");
        }
        return true;
    }

    public synchronized void logout() throws IOException {
        if (this.consumer != null) {
            this.consumer = null;
            this.save();
        }
    }

    public synchronized void invalidate() throws IOException {
        this.logout();
    }

    public synchronized Request signRequest(Request request) throws OAuthConsumerException {
        AssertUtils.notNull(request, "request");
        if (this.consumer == null) {
            throw new OAuthConsumerException("NO_CONSUMER");
        }
        try {
            return (Request)this.consumer.sign((Object)request).unwrap();
        }
        catch (OAuthException e) {
            log.debug((Object)"Error", (Throwable)e);
            return request;
        }
    }

    private class LoginResult {
        final String verifier;

        public LoginResult(String verifier) {
            this.verifier = verifier;
        }
    }
}

