/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.common.Messages;
import geocentral.common.app.Sysmon;
import geocentral.common.app.UserProfile;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteStatus;
import geocentral.common.data.GeocacheItem;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.api.GeocachingApiManager;
import geocentral.common.geocaching.api.IGeocachingApi;
import geocentral.common.map.Coords;
import geocentral.common.plugins.AbstractAsyncAction;
import geocentral.common.plugins.IConcurrencyContext;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ws.LoginRequiredException;
import java.io.IOException;
import java.util.List;
import org.bacza.utils.StringUtils;

public class GetGeocacheAction
extends AbstractAsyncAction {
    private final UserProfile profile;
    private List<FieldNoteItem> items;

    public GetGeocacheAction(UserProfile profile, List<FieldNoteItem> items) {
        this.profile = profile;
        this.items = items;
    }

    @Override
    public String getTaskName() {
        return Messages.getString("GetGeocacheAction.taskName");
    }

    @Override
    public IConcurrencyContext getConcurrencyContext() {
        return null;
    }

    @Override
    public void execute() {
        this.getAsyncContext().getMonitor().beginTask(this.getTaskName(), this.items.size());
        GeocacheSite site = null;
        try {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (GeocachingApiManager apis = new GeocachingApiManager(this.profile);){
                    for (FieldNoteItem item : this.items) {
                        if (this.isCanceled()) break;
                        site = item.getSite();
                        IGeocachingApi api = apis.getGeocachingApi(site);
                        String code = StringUtils.toUpperCase(item.getGeocacheCode());
                        String guid = item.getGuid();
                        String name = item.getGeocacheName();
                        boolean hasCode = StringUtils.notEmpty(code);
                        boolean hasGuid = StringUtils.notEmpty(guid);
                        boolean hasName = StringUtils.notEmpty(name);
                        boolean unsupported = false;
                        if (!hasCode && !hasGuid) continue;
                        String msg = hasName ? name : (hasCode ? code : guid);
                        this.getAsyncContext().getMonitor().subTask(msg);
                        GeocacheItem gc = null;
                        if (api == null) {
                            unsupported = true;
                        } else {
                            if (hasCode) {
                                gc = api.getGeocacheByCode(this.getAsyncContext(), code);
                            } else if (hasGuid) {
                                gc = api.getGeocacheByGuid(this.getAsyncContext(), guid);
                            }
                            if (gc != null) {
                                Sysmon.instance.postEvent(Sysmon.EventType.GEOCACHE_GET);
                            }
                        }
                        this.getAsyncContext().getMonitor().worked(1);
                        if (gc == null) {
                            if (unsupported) {
                                item.setFieldNoteStatus(FieldNoteStatus.NOT_SUPPORTED);
                                item.notifyChange();
                                continue;
                            }
                            if (DialogUtils.showErrorOkCancel(String.format(Messages.getString("GetGeocacheAction.error"), msg))) continue;
                            break;
                        }
                        if (gc.isPremiumOnly()) {
                            item.setFieldNoteStatus(FieldNoteStatus.NOT_SUPPORTED);
                            item.notifyChange();
                            continue;
                        }
                        item.setGeocacheCode(gc.getCode());
                        item.setGeocacheName(gc.getName());
                        item.setGeocacheOwner(gc.getOwner());
                        item.setType(gc.getType());
                        item.setSize(gc.getSize());
                        item.setRatingDifficulty(gc.getRatingDifficulty());
                        item.setRatingTerrain(gc.getRatingTerrain());
                        item.setHint(gc.getHint());
                        item.setFavPoints(gc.getFavPoints());
                        Coords coords = gc.getCoords();
                        if (coords != null && coords.isInitialized()) {
                            item.setLat(coords.getLat());
                            item.setLon(coords.getLon());
                        } else {
                            item.setLat(null);
                            item.setLon(null);
                        }
                        item.setRating(gc.getRating());
                        item.setRatingVotes(gc.getRatingVotes());
                        item.setPasswordRequired(gc.isPasswordRequired());
                        item.setNewLogLink(gc.getNewLogLink());
                        item.setExistingLogDate(gc.getExistingLogDate());
                        item.setExistingLogType(gc.getExistingLogType());
                        item.setExistingLogChecked(true);
                        item.updateFieldNoteStatus();
                        item.notifyChange();
                    }
                    this.getAsyncContext().getMonitor().done();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.getAsyncContext().getMonitor().done();
                MessageUtils.showIOException(e);
                this.getAsyncContext().getMonitor().done();
            }
            catch (LoginRequiredException lre) {
                this.getAsyncContext().getMonitor().done();
                this.profile.removeSiteProfile(site);
                MessageUtils.showLoginRequiredError(lre);
                this.getAsyncContext().getMonitor().done();
            }
        }
        finally {
            this.getAsyncContext().getMonitor().done();
        }
    }
}

