/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.api.groundspeak.GcWebService;
import geocentral.common.Messages;
import geocentral.common.app.UserProfile;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.FieldNoteImportUtils;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.plugins.AbstractAsyncAction;
import geocentral.common.plugins.IConcurrencyContext;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ws.LoginRequiredException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class GetFieldNotesAction
extends AbstractAsyncAction {
    private static final Log log = LogFactory.getLog(GetFieldNotesAction.class);
    private final UserProfile profile;
    private List<FieldNoteItem> items;

    public GetFieldNotesAction(UserProfile profile, List<FieldNoteItem> items) {
        AssertUtils.notNull(profile, "profile");
        this.profile = profile;
        this.items = items;
    }

    @Override
    public String getTaskName() {
        return Messages.getString("GetFieldNotesAction.taskName");
    }

    @Override
    public IConcurrencyContext getConcurrencyContext() {
        return null;
    }

    @Override
    public void execute() {
        log.debug((Object)"Getting field notes...");
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (GcWebService ws = new GcWebService(this.profile);){
                this.getAsyncContext().getMonitor().beginTask(this.getTaskName(), -1);
                this.items.clear();
                List<FieldNoteItem> newItems = ws.getFieldNotes(this.getAsyncContext());
                if (newItems != null) {
                    this.items.addAll(newItems);
                    FieldNoteImportUtils.deduplicateFieldNotes(this.items);
                    FieldNoteImportUtils.handleOptions(newItems);
                    if (newItems.size() > 0) {
                        if (DialogUtils.showConfirm(Messages.getString("GetFieldNotesAction.confirmGetDetails"))) {
                            this.getDetails(ws, newItems);
                        } else {
                            LinkedList<FieldNoteItem> incompleteItems = new LinkedList<FieldNoteItem>();
                            for (FieldNoteItem item : newItems) {
                                if (item.getLogType() != null) continue;
                                incompleteItems.add(item);
                            }
                            if (incompleteItems.size() > 0) {
                                DialogUtils.showInfo(Messages.getString("GetFieldNotesAction.infoIncompleteItems"));
                                this.getDetails(ws, incompleteItems);
                            }
                        }
                    }
                }
                log.debug((Object)"Getting field notes done.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
            MessageUtils.showIOException(e);
        }
        catch (LoginRequiredException e) {
            log.debug((Object)"Error", (Throwable)e);
            this.profile.removeSiteProfile(GeocacheSite.GC);
            MessageUtils.showLoginRequiredError(e);
        }
    }

    private void getDetails(GcWebService ws, List<FieldNoteItem> items) throws IOException, LoginRequiredException {
        try {
            this.getAsyncContext().getMonitor().beginTask(Messages.getString("GetFieldNotesAction.taskNameDetails"), items.size());
            for (FieldNoteItem item : items) {
                if (this.isCanceled()) {
                    return;
                }
                this.getAsyncContext().getMonitor().subTask(StringUtils.coalesce(item.getGeocacheName(), item.getGeocacheCode(), Messages.getString("GetFieldNotesAction.unknownCacheName")));
                ws.getFieldNoteDetails(this.getAsyncContext(), item);
                item.notifyChange();
                this.getAsyncContext().getMonitor().worked(1);
            }
        }
        finally {
            this.done();
        }
    }
}

