/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui;

import geocentral.common.Messages;
import geocentral.common.geocaching.GeocacheLogTextConverter;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.TabTraverseListener;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.List;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditFieldNoteDialog
extends TitleAreaDialog {
    private String logText;
    private Text textLogMessage;
    private Label lblLengthValue;

    public EditFieldNoteDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68720);
    }

    public String getLogText() {
        return this.logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("EditFieldNoteDialog.title"));
        this.setMessage(Messages.getString("EditFieldNoteDialog.message"));
        parent.getShell().setMinimumSize(480, 360);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblLogMessage = new Label(container, 0);
        lblLogMessage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblLogMessage.setText(Messages.getString("EditFieldNoteDialog.comment"));
        this.textLogMessage = new Text(container, 2626);
        this.textLogMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditFieldNoteDialog.this.calcLengthValue();
            }
        });
        this.textLogMessage.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblLength = new Label(container, 0);
        lblLength.setText(Messages.getString("EditFieldNoteDialog.characters"));
        lblLength.setToolTipText(Messages.getString("EditFieldNoteDialog.charactersHint"));
        this.lblLengthValue = new Label(container, 0);
        this.lblLengthValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblLengthValue.setText("0");
        this.textLogMessage.addTraverseListener((TraverseListener)new TabTraverseListener(true));
        this.textLogMessage.setText(StringUtils.nvl(this.getLogText()));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 94, 24);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        return WidgetSizeUtils.getCenteredLocation((Control)this.getParentShell(), initialSize);
    }

    protected void okPressed() {
        if (this.checkInput()) {
            this.saveInput();
            super.okPressed();
        }
    }

    private boolean checkInput() {
        String token;
        int index;
        List<String> tokens;
        GeocacheLogTextConverter converter = new GeocacheLogTextConverter();
        String text = this.textLogMessage.getText();
        if (converter.hasTokens(text) && (tokens = converter.getInvalidTokens()).size() > 0 && (index = text.indexOf(token = tokens.get(0))) >= 0) {
            DialogUtils.showError(String.format(Messages.getString("EditFieldNoteDialog.invalidTokenNameOrParams"), token));
            this.textLogMessage.setSelection(index, index + token.length());
            this.textLogMessage.showSelection();
            this.textLogMessage.forceFocus();
            return false;
        }
        return true;
    }

    private void saveInput() {
        this.setLogText(this.textLogMessage.getText());
    }

    private void calcLengthValue() {
        String text = this.textLogMessage.getText();
        int len = text != null ? text.length() : 0;
        this.lblLengthValue.setText(String.valueOf(len));
    }
}

