/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.mappers.WaypointTypeMapper;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.stats.GeocacheTypeCounter;
import java.util.LinkedList;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ProfileGeocachesParser {
    private static final WaypointTypeMapper wptTypeMapper = new WaypointTypeMapper();
    private GeocacheTypeCounter geocacheTypeStats;

    public ProfileGeocachesParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        Element main = root.getElementById("ctl00_ContentBody_ProfilePanel1_pnlStats");
        ParseAssert.notNull(main, 1000);
        Element table = main.select("table").first();
        ParseAssert.notNull(table, 1100);
        Elements trs = table.select("tbody > tr");
        ParseAssert.notNull(trs, 1110);
        GeocacheTypeCounter stats = new GeocacheTypeCounter();
        LinkedList<Stats> list = new LinkedList<Stats>();
        int subelementCount = 0;
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            ParseAssert.notNull(tds, 1200);
            ParseAssert.check(tds.size() == 2, 1201);
            Element a = tds.get(0).getElementsByTag("a").first();
            ParseAssert.notNull(a, 1210);
            String id = a.attr("id");
            ParseAssert.notNull(id, 1212);
            boolean isSubelement = id.contains("uxSubTaxonomyTypes");
            if (isSubelement) {
                if (++subelementCount == 1 && list.size() > 0) {
                    list.remove(list.size() - 1);
                }
            } else {
                subelementCount = 0;
            }
            Element img = tds.get(0).getElementsByTag("img").first();
            ParseAssert.notNull(img, 1300);
            String src = img.attr("src");
            ParseAssert.notNull(src, 1301);
            String geocacheTypeStr = src.replaceAll(".+/([^.]+).(gif|png)", "$1");
            ParseAssert.notNull(geocacheTypeStr, 1302);
            GeocacheType geocacheType = wptTypeMapper.getMappedValue(geocacheTypeStr, null);
            ParseAssert.notNull((Object)geocacheType, 1303);
            Element span = tds.get(1).getElementsByTag("span").first();
            ParseAssert.notNull(span, 1400);
            String text = span.text();
            ParseAssert.notNull(text, 1401);
            text = text.replace(".", "");
            text = text.replace(",", "");
            ParseAssert.check(StringUtils.notEmpty(text), 1402);
            int count = StringUtils.parseInt(text, -1);
            ParseAssert.check(count >= 0, 1403);
            list.add(new Stats(geocacheType, count));
        }
        for (Stats s : list) {
            stats.setValueByGroup(s.geocacheType, s.count);
        }
        Element tr2 = table.select("tfoot > tr").first();
        ParseAssert.notNull(tr2, 1500);
        Elements tds = tr2.select("td");
        ParseAssert.notNull(tds, 1502);
        ParseAssert.check(tds.size() == 2, 1504);
        String totalStr = tds.get(1).text();
        ParseAssert.notNull(totalStr, 1506);
        totalStr = totalStr.replace(".", "");
        totalStr = totalStr.replace(",", "");
        ParseAssert.check(StringUtils.notEmpty(totalStr), 1508);
        int totalCount = StringUtils.parseInt(totalStr, -1);
        ParseAssert.check(totalCount >= 0, 1510);
        ParseAssert.check(totalCount == stats.getValue(), 1520);
        this.geocacheTypeStats = stats;
    }

    public GeocacheTypeCounter getGeocacheTypeStats() {
        return this.geocacheTypeStats;
    }

    class Stats {
        public final GeocacheType geocacheType;
        public final int count;

        public Stats(GeocacheType geocacheType, int count) {
            this.geocacheType = geocacheType;
            this.count = count;
        }

        public String toString() {
            return String.format("%s: %d", new Object[]{this.geocacheType, this.count});
        }
    }
}

