/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.mappers.WaypointTypeMapper;
import geocentral.common.data.GeocacheItem;
import geocentral.common.geocaching.GeocacheType;
import java.util.LinkedList;
import java.util.List;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MyCachesParser {
    private static final WaypointTypeMapper wptTypeMapper = new WaypointTypeMapper();
    private List<GeocacheItem> geocaches = new LinkedList<GeocacheItem>();

    public MyCachesParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        Element div = root.getElementById("divContentMain");
        ParseAssert.notNull(div, 1000);
        Element tab = div.getElementsByTag("table").first();
        if (tab == null) {
            return;
        }
        Elements rows = tab.select("tbody > tr");
        ParseAssert.notNull(rows, 1020);
        for (Element row : rows) {
            String[] tokens;
            Elements cols = row.getElementsByTag("td");
            if (cols.size() == 0) continue;
            ParseAssert.check(cols.size() == 8, 1030);
            GeocacheItem gc = new GeocacheItem();
            GeocacheType geocacheType = this.getGeocacheTypeByImg(cols.get(2));
            gc.setType(geocacheType);
            Elements spans = cols.get(3).select("span");
            ParseAssert.check(spans.size() == 2, 1035);
            String cacheName = spans.get(0).text();
            gc.setName(cacheName);
            String span = spans.get(1).text();
            if (span != null && (tokens = span.split("\\|")) != null && tokens.length == 3) {
                String code;
                String owner = tokens[0].trim();
                if (owner.startsWith("by ")) {
                    owner = owner.replaceFirst("by ", "");
                    gc.setOwner(owner);
                }
                if ((code = tokens[1].trim()).startsWith("GC")) {
                    gc.setCode(code);
                }
            }
            if (!StringUtils.notEmpty(gc.getCode())) continue;
            this.geocaches.add(gc);
        }
    }

    private GeocacheType getGeocacheTypeByImg(Element element) {
        String src;
        Element img;
        if (element != null && (img = element.getElementsByTag("img").first()) != null && (src = img.attr("src")) != null) {
            String logTypeStr = src.replaceAll(".+/([^.]+).(gif|png)", "$1");
            return wptTypeMapper.getMappedValue(logTypeStr, null);
        }
        return null;
    }

    public List<GeocacheItem> getGeocaches() {
        return this.geocaches;
    }
}

