/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.jsoup.nodes.Element;

public class LogResponseParser {
    private boolean confirm = false;
    private String confirmMessage = null;

    public LogResponseParser(Element root) throws ParseException {
        this.parse(root);
    }

    public boolean getConfirm() {
        return this.confirm;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        Element main = root.getElementById("ctl00_ContentBody_LogBookPanel1_ViewLogPanel");
        if (main != null) {
            this.parseLogPanel(main);
            return;
        }
        main = root.getElementById("ctl00_ContentBody_LogBookPanel1_ConfirmPanel");
        if (main != null) {
            this.parseConfirmPanel(main);
            return;
        }
        ParseAssert.notNull(main, 1000);
    }

    private void parseLogPanel(Element main) throws ParseException {
        Element logHeader = main.getElementById("ctl00_ContentBody_LogBookPanel1_lbLogText");
        ParseAssert.notNull(logHeader, 1100);
        String logHeaderText = logHeader.text();
        ParseAssert.notEmpty(logHeaderText, 1110);
    }

    private void parseConfirmPanel(Element main) throws ParseException {
        this.confirm = true;
        Element confirm = main.getElementById("ctl00_ContentBody_LogBookPanel1_lbConfirm");
        ParseAssert.notNull(confirm, 1200);
        this.confirmMessage = confirm.text();
        ParseAssert.notEmpty(this.confirmMessage, 1210);
    }
}

