/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.EmbeddedJsonParser;
import geocentral.api.groundspeak.FormValueNames;
import geocentral.api.groundspeak.GcAuthToken;
import geocentral.api.groundspeak.GcCsrfToken;
import geocentral.api.groundspeak.GcLoginAssert;
import geocentral.api.groundspeak.GcUserPrefUtils;
import geocentral.api.groundspeak.GcWebExecutor;
import geocentral.api.groundspeak.GeocacheParser;
import geocentral.api.groundspeak.InvalidLogTypeException;
import geocentral.api.groundspeak.MyCachesParser;
import geocentral.api.groundspeak.PocketQueryMeta;
import geocentral.api.groundspeak.PocketQueryParser;
import geocentral.api.groundspeak.PreferencesMeta;
import geocentral.api.groundspeak.ProfileGeocachesParser;
import geocentral.api.groundspeak.json.GetTokenParser;
import geocentral.api.groundspeak.json.LogDraftsDataParser;
import geocentral.api.groundspeak.json.LogDraftsParser;
import geocentral.api.groundspeak.mappers.LogType2IdMapper;
import geocentral.common.app.SiteProfile;
import geocentral.common.app.StorageService;
import geocentral.common.app.UserProfile;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.DataReaderUtils;
import geocentral.common.data.DataStoreListAdapter;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.GeocacheItem;
import geocentral.common.data.parsers.IUserParser;
import geocentral.common.data.parsers.JsonParser;
import geocentral.common.data.parsers.ParserException;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.GeocachingTaskNames;
import geocentral.common.geocaching.api.IGeocachingApi;
import geocentral.common.geocaching.api.LogFormat;
import geocentral.common.geocaching.api.LogOptions;
import geocentral.common.geocaching.api.PostLogResult;
import geocentral.common.plugins.AsyncContext;
import geocentral.common.stats.GeocacheTypeCounter;
import geocentral.common.ui.CommonMessages;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import geocentral.common.ws.LoginRequiredException;
import geocentral.common.ws.WsTaskInfo;
import geocentral.common.ws.WsUtils;
import geocentral.http.WebClientManager;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.html.DocumentData;
import org.bacza.data.html.FormData;
import org.bacza.data.html.FormDataUtils;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValue;
import org.bacza.data.html.FormValueOption;
import org.bacza.data.html.LoginAssert;
import org.bacza.data.json.JSONUtils;
import org.bacza.data.json.JWTHelper;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.RequestUtils;
import org.bacza.http.URLUtils;
import org.bacza.http.WebClient;
import org.bacza.http.WebResponse;
import org.bacza.http.WebResponseUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.CalendarUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringPair;
import org.bacza.utils.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcWebService
implements IGeocachingApi {
    private static final Log log = LogFactory.getLog(GcWebService.class);
    public static final GeocacheSite SITE = GeocacheSite.GC;
    public static final String SITE_NAME = SITE.getSiteName();
    public static final LogOptions LOG_OPTIONS = new LogOptions(4000, LogFormat.TEXT, LogFormat.MD);
    private static final String BASE_URL_HTTPS = "https://www.geocaching.com/";
    private static final String LOGS_PATH = StorageService.getInstance().getLogsPath("geocaching.com");
    private final WebClient client;
    private GcAuthToken authToken;
    private GcCsrfToken csrfToken;
    private DocumentData htmlData;
    private boolean logPages = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.devel.log_pages");

    protected void print(String msg, Object ... args) {
        log.trace((Object)String.format(msg, args));
    }

    private static String getUrl(String path) {
        return URLUtils.absAsString(BASE_URL_HTTPS, path);
    }

    public static String getListingUrlByCode(String code) {
        return GcWebService.getUrl(String.format("/seek/cache_details.aspx?wp=%s", code));
    }

    public static String getListingUrlByGuid(String guid) {
        return GcWebService.getUrl(String.format("/seek/cache_details.aspx?guid=%s", guid));
    }

    public GcWebService(UserProfile profile) {
        this.client = WebClientManager.getInstance().getClient(profile).newClient(new GcWebExecutor());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public GeocacheSite getSite() {
        return SITE;
    }

    private void saveCurrentState(Document doc) {
        this.htmlData = new DocumentData((Element)doc);
    }

    protected WsTaskInfo getTaskInfo(String task) {
        return new WsTaskInfo(SITE_NAME, task);
    }

    protected GcAuthToken getAuthToken(AsyncContext ctx, WsTaskInfo info) throws IOException, ParseException, LoginRequiredException {
        if (this.authToken == null || this.authToken != null && this.authToken.hasExpired()) {
            this.authToken = this.getAuthTokenImpl(ctx, info);
        }
        if (this.authToken == null) {
            throw new IOException("Error getting auth token");
        }
        if (!StringUtils.equalsIgnoreCase(this.authToken.getType(), "bearer")) {
            throw new IOException("Unsupported auth token type");
        }
        if (StringUtils.isEmpty(this.authToken.getToken())) {
            throw new IOException("Empty auth token");
        }
        return this.authToken;
    }

    protected GcAuthToken getAuthTokenImpl(AsyncContext ctx, WsTaskInfo info) throws IOException, ParseException, LoginRequiredException {
        log.trace((Object)"Requesting auth token...");
        Request request = RequestUtils.get(GcWebService.getUrl("/account/oauth/token"));
        Throwable throwable = null;
        Object var5_6 = null;
        try (WebResponse response = this.client.execute(request);){
            if (!WebResponseUtils.isJsonResponse(response)) {
                WsUtils.getDocDataWithLoginCheck(response, info);
                throw new ParseException("Invalid content type");
            }
            String json = response.getContentText();
            try {
                DataReaderContext readerContext = DataReaderUtils.createDataReaderContext(ctx.getMonitor());
                GetTokenParser parser = new GetTokenParser(readerContext);
                JsonParser.parse(json, (IUserParser)parser);
                return parser.getToken();
            }
            catch (ParserException e) {
                log.debug((Object)"Error", (Throwable)e);
                throw new ParseException(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String getCsrfToken(AsyncContext ctx, WsTaskInfo info) throws IOException, ParseException, LoginRequiredException {
        if (this.csrfToken == null || this.csrfToken != null && this.csrfToken.isExpired()) {
            this.csrfToken = this.getCsrfTokenImpl(ctx, info);
        }
        if (this.csrfToken == null) {
            throw new IOException("Error getting auth token");
        }
        if (StringUtils.isEmpty(this.csrfToken.getToken())) {
            throw new IOException("Empty auth token");
        }
        return this.csrfToken.getToken();
    }

    protected GcCsrfToken getCsrfTokenImpl(AsyncContext ctx, WsTaskInfo info) throws IOException, ParseException, LoginRequiredException {
        log.trace((Object)"Requesting auth token...");
        Request request = RequestUtils.get(GcWebService.getUrl("/api/auth/csrf"));
        Throwable throwable = null;
        Object var5_6 = null;
        try (WebResponse response = this.client.execute(request);){
            if (!WebResponseUtils.isJsonResponse(response)) {
                WsUtils.getDocDataWithLoginCheck(response, info);
                throw new ParseException("Invalid content type");
            }
            try {
                String text = response.getContentText();
                JSONObject json = new JSONObject(text);
                return new GcCsrfToken(json.optString("csrfToken", null));
            }
            catch (JSONException e) {
                log.debug((Object)"Error", (Throwable)e);
                throw new ParseException(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SiteProfile getUserInfo(AsyncContext ctx) throws IOException, ParseException, LoginRequiredException {
        AssertUtils.notNull(ctx, "ctx");
        log.trace((Object)"Getting user info...");
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_USER_INFO);
        GcAuthToken token = this.getAuthToken(ctx, info);
        JWTHelper jwt = new JWTHelper(token.getToken());
        String login = jwt.getClaimAsString("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name");
        String id = jwt.getClaimAsString("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier");
        String uuid = jwt.getClaimAsString("pgd");
        SiteProfile profile = new SiteProfile(this.getSite(), id, uuid, login);
        return profile;
    }

    @Override
    public boolean login(AsyncContext ctx, String username, String password) throws IOException, ParseException, LoginRequiredException {
        block21: {
            log.trace((Object)"Logging in...");
            WsTaskInfo info = new WsTaskInfo(this.getSite().getSiteName(), GeocachingTaskNames.TASK_LOGIN, GeocachingTaskNames.TASK_DETAILS_LOGIN_ERR);
            Request request = RequestUtils.get(GcWebService.getUrl("/account/signin"));
            Throwable throwable = null;
            Object var7_8 = null;
            WebResponse response = this.client.execute(request);
            try {
                URI baseUri = response.getLastURI();
                String html = response.getContentText();
                this.writeFile("login-1.txt", html);
                Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
                DocumentData htmlData = new DocumentData((Element)doc);
                FormData form = LoginAssert.findLoginForm(htmlData, FormValueNames.NAMES_LOGIN);
                if (form != null) {
                    AssertUtils.checkArgument(form.containsAllValues(FormValueNames.NAMES_LOGIN), CommonMessages.MSG_INV_RESP);
                    FormDataUtils.setValue(form, "UsernameOrEmail", username);
                    FormDataUtils.setValue(form, "Password", password);
                    String url = URLUtils.absAsString(baseUri, form.getAction());
                    Request post = RequestUtils.post(url, form.getFormData());
                    Throwable throwable2 = null;
                    Object var17_20 = null;
                    try (WebResponse response2 = this.client.execute(post);){
                        html = response2.getContentText();
                        this.writeFile("login-2.txt", html);
                        doc = Jsoup.parse((String)html);
                        htmlData = new DocumentData((Element)doc);
                        form = LoginAssert.findPasswordForm(htmlData);
                        if (form != null && form.containsAnyValue(FormValueNames.NAMES_RECAPTCHA)) {
                            log.info((Object)"reCAPTCHA challenge detected!");
                            MessageUtils.showRecapNotSupportedError();
                        }
                        LoginAssert.checkPasswordInput(htmlData, info);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                GcLoginAssert.checkLoggedIn(doc, htmlData, info);
                if (response == null) break block21;
            }
            catch (Throwable throwable4) {
                try {
                    if (response != null) {
                        response.close();
                    }
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            response.close();
        }
        return true;
    }

    @Override
    public boolean logout(AsyncContext ctx) throws IOException, ParseException, LoginRequiredException {
        block9: {
            log.trace((Object)"Logging out...");
            LinkedList<StringPair> params = new LinkedList<StringPair>();
            params.add(new StringPair("returnUrl", GcWebService.getUrl("/play/search")));
            Request post = RequestUtils.post(GcWebService.getUrl("/account/logout"), params);
            Throwable throwable = null;
            Object var5_6 = null;
            WebResponse response = this.client.execute(post);
            try {
                URI baseUri = response.getLastURI();
                String html = response.getContentText();
                Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
                DocumentData htmlData = new DocumentData((Element)doc);
                FormData form = LoginAssert.findPasswordForm(htmlData);
                ParseAssert.notNull(form, 1000);
                if (response == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    if (response != null) {
                        response.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            response.close();
        }
        return true;
    }

    public PreferencesMeta getUserPreferences(AsyncContext ctx) throws IOException, LoginRequiredException {
        int maxMinutes = 10;
        if (!GcUserPrefUtils.getInstance().hasCurrentPreferencesMinutes(10)) {
            PreferencesMeta preferences = this.getUserPreferencesImpl(ctx);
            GcUserPrefUtils.getInstance().setPreferences(preferences);
        }
        return GcUserPrefUtils.getInstance().getPreferences();
    }

    private PreferencesMeta getUserPreferencesImpl(AsyncContext ctx) throws IOException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_USER_PREFS);
        Request request = RequestUtils.get(GcWebService.getUrl("/account/settings/preferences"));
        Throwable throwable = null;
        Object var5_6 = null;
        try (WebResponse response = this.client.execute(request);){
            URI baseUri = response.getLastURI();
            String html = response.getContentText();
            this.writeFile("preferences.txt", html);
            Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
            DocumentData htmlData = new DocumentData((Element)doc);
            GcLoginAssert.checkLoggedIn(doc, htmlData, info);
            FormData form = htmlData.getMatchingForm(FormValueNames.NAMES_PREFERENCES);
            AssertUtils.checkArgument(form != null, CommonMessages.MSG_INV_RESP);
            if (form != null) {
                PreferencesMeta prefs = new PreferencesMeta();
                prefs.setLanguage(FormDataUtils.getSelectedOptionValue(form, "SelectedCultureCode"));
                prefs.setTimeZone(FormDataUtils.getSelectedOptionId(form, "SelectedTimeZone"));
                prefs.setDateFormat(FormDataUtils.getSelectedOptionValue(form, "SelectedDateFormat"));
                prefs.setUnits(FormDataUtils.getSelectedOptionValue(form, "DistanceUnits"));
                prefs.setGpxVersion(FormDataUtils.getSelectedOptionValue(form, "SelectedGPXVersion"));
                return prefs;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    protected void myLogs() {
        Request request = RequestUtils.get(GcWebService.getUrl("/seek/nearest.aspx?ul=bacza"));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WebResponse response = this.client.execute(request);){
                String html = response.getContentText();
                this.writeFile("seek-nearest-bacza-1.html", html);
                Document doc = Jsoup.parse((String)html);
                this.saveCurrentState(doc);
                if (this.htmlData.getFormCount() > 0) {
                    FormData form = this.htmlData.getForm(0);
                    this.printFormData(form);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
    }

    protected void parseFile() throws IOException {
        String html = FileUtils.readFileAsString("test-play-search-1.html");
        Document doc = Jsoup.parse((String)html);
        DocumentData htmlData = new DocumentData((Element)doc);
        FormData form = htmlData.getFirstForm();
        if (form != null) {
            this.printFormData(form);
            AssertUtils.checkArgument(form.containsAllValues(FormValueNames.NAMES_PLAY_SEARCH), CommonMessages.MSG_INV_RESP);
            FormDataUtils.setValue(form, "SearchFiltersViewModel.OriginKeyword", "N 52\u00b0 12.424 E 21\u00b0 02.912");
            FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.OriginTreatment", false);
            FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.OriginTreatment", "AsCoords", true);
            FormDataUtils.setValue(form, "SearchFiltersViewModel.NonLimitingRegionId", "");
            FormDataUtils.setValue(form, "SearchFiltersViewModel.SearchRadiusViewModel.Radius", "16");
            FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.GeocacheTypeIds", true);
            FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.ContainerTypeIds", true);
            FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Difficulty.Min", "1", true);
            FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Difficulty.Max", "5", true);
            FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Terrain.Min", "1", true);
            FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Terrain.Max", "5", true);
            FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.SelectedAvailableCountriesAndRegions", false);
            FormDataUtils.removeAllOptions(form, "SearchFiltersViewModel.CountryIds");
            FormDataUtils.removeAllOptions(form, "SearchFiltersViewModel.RegionIds");
            String data = form.getFormDataAsString();
            System.out.println(data);
        }
    }

    protected void search1() {
        Request request = RequestUtils.get(GcWebService.getUrl("/seek/nearest.aspx?ul=bacza"));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WebResponse response = this.client.execute(request);){
                String html = response.getContentText();
                this.writeFile("nearest-bacza-1.html", html);
                Document doc = Jsoup.parse((String)html);
                this.saveCurrentState(doc);
                if (this.htmlData.getFormCount() > 0) {
                    FormData form = this.htmlData.getForm(0);
                    this.printFormData(form);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
    }

    protected void playSearch1() {
        Request request = RequestUtils.get(GcWebService.getUrl("/play/search"));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WebResponse response = this.client.execute(request);){
                String html = response.getContentText();
                this.writeFile("play-search-1.html", html);
                Document doc = Jsoup.parse((String)html);
                this.saveCurrentState(doc);
                if (this.htmlData.getFormCount() > 0) {
                    FormData form = this.htmlData.getForm(0);
                    this.printFormData(form);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
    }

    protected void playSearchCoords(String coords) {
        block20: {
            Request request = RequestUtils.get(GcWebService.getUrl("/play/search"));
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (WebResponse response = this.client.execute(request);){
                    String html = response.getContentText();
                    this.writeFile("play-search-coords.html", html);
                    Document doc = Jsoup.parse((String)html);
                    this.saveCurrentState(doc);
                    FormData form = this.htmlData.getFirstForm();
                    if (form == null) break block20;
                    AssertUtils.checkArgument(form.containsAllValues(FormValueNames.NAMES_PLAY_SEARCH), CommonMessages.MSG_INV_RESP);
                    FormDataUtils.setValue(form, "SearchFiltersViewModel.OriginKeyword", coords);
                    FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.OriginTreatment", false);
                    FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.OriginTreatment", "AsCoords", true);
                    FormDataUtils.setValue(form, "SearchFiltersViewModel.NonLimitingRegionId", "");
                    FormDataUtils.setValue(form, "SearchFiltersViewModel.SearchRadiusViewModel.Radius", "4");
                    FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.GeocacheTypeIds", true);
                    FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.ContainerTypeIds", true);
                    FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Difficulty.Min", "1", true);
                    FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Difficulty.Max", "5", true);
                    FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Terrain.Min", "1", true);
                    FormDataUtils.selectOptionById(form, "SearchFiltersViewModel.Terrain.Max", "5", true);
                    FormDataUtils.selectAllOptions(form, "SearchFiltersViewModel.SelectedAvailableCountriesAndRegions", false);
                    FormDataUtils.removeAllOptions(form, "SearchFiltersViewModel.CountryIds");
                    FormDataUtils.removeAllOptions(form, "SearchFiltersViewModel.RegionIds");
                    String data = form.getFormDataAsString();
                    System.out.println(data);
                    Request post = RequestUtils.post(GcWebService.getUrl(form.getAction()), form.getFormData());
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (WebResponse response2 = this.client.execute(post);){
                        html = response2.getContentText();
                        this.writeFile("play-search-coords-response.html", html);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.debug((Object)"Error", (Throwable)e);
            }
        }
    }

    public List<FieldNoteItem> getFieldNotes(AsyncContext ctx) throws IOException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_FIELD_NOTES);
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        try {
            int step;
            int skip = 0;
            int count = step = 20;
            while (count == step) {
                if (ctx.getMonitor().isCanceled()) {
                    return null;
                }
                GcAuthToken token = this.getAuthToken(ctx, info);
                String url = String.format("/api/proxy/web/v1/LogDrafts?sortAsc=true&skip=%d&take=%d", skip, step);
                Request request = RequestUtils.get(GcWebService.getUrl(url));
                Throwable throwable = null;
                Object var11_14 = null;
                try (WebResponse response = this.client.execute(request);){
                    String resp = response.getContentText();
                    LinkedList items = new LinkedList();
                    DataStoreListAdapter store = new DataStoreListAdapter(items);
                    DataReaderContext rctx = DataReaderUtils.createDataReaderContext(ctx.getMonitor(), store);
                    LogDraftsParser parser = new LogDraftsParser(rctx);
                    JsonParser.parse(resp, (IUserParser)parser);
                    skip += step;
                    count = items.size();
                    result.addAll(items);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            LinkedList<FieldNoteItem> linkedList = result;
            return linkedList;
        }
        catch (ParseException e) {
            log.debug((Object)"Error", (Throwable)e);
            ctx.getMonitor().done();
            MessageUtils.showParseException(e);
        }
        catch (ParserException e) {
            log.debug((Object)"Error", (Throwable)e);
            ctx.getMonitor().done();
            MessageUtils.showException(e);
        }
        finally {
            ctx.getMonitor().done();
        }
        return null;
    }

    public List<GeocacheItem> getMyCaches(AsyncContext ctx) throws IOException, LoginRequiredException {
        block18: {
            WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_MY_CACHES);
            try {
                List<GeocacheItem> list;
                block17: {
                    Request request = RequestUtils.get(GcWebService.getUrl("/my/owned.aspx"));
                    if (ctx.getMonitor().isCanceled()) {
                        return null;
                    }
                    Throwable throwable = null;
                    Object var5_7 = null;
                    WebResponse response = this.client.execute(request);
                    try {
                        List<GeocacheItem> geocaches;
                        URI baseUri = response.getLastURI();
                        String html = response.getContentText();
                        this.writeFile("owned.txt", html);
                        Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
                        DocumentData htmlData = new DocumentData((Element)doc);
                        GcLoginAssert.checkLoggedIn(doc, htmlData, info);
                        MyCachesParser parser = new MyCachesParser((Element)doc);
                        list = geocaches = parser.getGeocaches();
                        if (response == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (response != null) {
                                    response.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)"Error", (Throwable)e);
                            ctx.getMonitor().done();
                            MessageUtils.showParseException(e);
                            break block18;
                        }
                    }
                    response.close();
                }
                return list;
            }
            finally {
                ctx.getMonitor().done();
            }
        }
        return null;
    }

    protected void pqList() {
        Request request = RequestUtils.get(GcWebService.getUrl("/pocket/"));
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (WebResponse response = this.client.execute(request);){
                String html = response.getContentText();
                this.writeFile("pocket.txt", html);
                Document doc = Jsoup.parse((String)html);
                PocketQueryParser parser = new PocketQueryParser((Element)doc);
                List<PocketQueryMeta> pqs = parser.getPQList();
                Date dateServer = parser.getServerTime();
                Date dateLocal = new Date();
                this.print("Server time: " + dateServer, new Object[0]);
                this.print("Local  time: " + dateLocal, new Object[0]);
                this.print("Time difference: %f (hours)", DateUtils.getHoursBetween(dateServer, dateLocal));
                Date now = new Date();
                for (PocketQueryMeta pq : pqs) {
                    if (!(DateUtils.getDaysBetween(pq.getLastGenerated(), now) <= 14.0)) continue;
                    Date last = pq.getLastGenerated();
                    this.print("PQ: name=%s, gen=%s (%.1f days ago) day of week=%d (%d)", pq.getName(), last, DateUtils.getDaysBetween(pq.getLastGenerated(), now), CalendarUtils.getDayOfWeek(last), CalendarUtils.getDayOfWeek(last, "PST"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
        catch (ParseException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
    }

    protected void pqMarkDayOfWeek(PocketQueryMeta pq, int dayOfWeek, boolean mark) {
        Request request = RequestUtils.get(GcWebService.getUrl("/pocket/default.aspx?pq=%s&d=%d&opt=%d"));
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (WebResponse response = this.client.execute(request);){
                String html = response.getContentText();
                this.writeFile("pocket.txt", html);
                Document doc = Jsoup.parse((String)html);
                PocketQueryParser parser = new PocketQueryParser((Element)doc);
                List<PocketQueryMeta> list = parser.getPQList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
        catch (ParseException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
    }

    @Override
    public GeocacheItem getGeocacheByCode(AsyncContext ctx, String code) throws IOException, LoginRequiredException {
        Request request = RequestUtils.get(GcWebService.getListingUrlByCode(code));
        return this.getGeocache(ctx, request);
    }

    @Override
    public GeocacheItem getGeocacheByGuid(AsyncContext ctx, String guid) throws IOException, LoginRequiredException {
        Request request = RequestUtils.get(GcWebService.getListingUrlByGuid(guid));
        return this.getGeocache(ctx, request);
    }

    protected GeocacheItem getGeocache(AsyncContext ctx, Request request) throws IOException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_GEOCACHE);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (WebResponse response = this.client.execute(request);){
                URI baseUri = response.getLastURI();
                String html = response.getContentText();
                Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
                DocumentData htmlData = new DocumentData((Element)doc);
                GcLoginAssert.checkLoggedIn(doc, htmlData, info);
                PreferencesMeta prefs = this.getUserPreferences(ctx);
                GeocacheParser parser = new GeocacheParser((Element)doc, prefs);
                GeocacheItem gc = parser.getGeocache();
                return gc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParseException e) {
            log.debug((Object)"Error", (Throwable)e);
            MessageUtils.showParseException(e);
            return null;
        }
    }

    private Integer mapLogType(GeocacheLogType logType) throws InvalidLogTypeException {
        Integer id = LogType2IdMapper.mapLogType(logType);
        if (id == null) {
            throw new InvalidLogTypeException(logType);
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GeocacheTypeCounter getUserStats(IProgressMonitor monitor) throws IOException, LoginRequiredException {
        log.trace((Object)"Getting user stats...");
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_USER_STATS);
        Request request = RequestUtils.get(GcWebService.getUrl("/profile/"));
        try {
            Object html322;
            if (monitor.isCanceled()) {
                return null;
            }
            Document doc = null;
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                URI baseUri2;
                WebResponse response2;
                block29: {
                    response2 = this.client.execute(request);
                    baseUri2 = response2.getLastURI();
                    if (!monitor.isCanceled()) break block29;
                    if (response2 == null) return null;
                    response2.close();
                    return null;
                }
                try {
                    html322 = response2.getContentText();
                    this.writeFile("profile-1.txt", (String)html322);
                    doc = Jsoup.parse((String)html322, (String)baseUri2.toASCIIString());
                }
                finally {
                    if (response2 != null) {
                        response2.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
            DocumentData data = new DocumentData((Element)doc);
            GcLoginAssert.checkLoggedIn(doc, data, info);
            FormData form = data.getFirstForm();
            AssertUtils.notNull(form, "Form Data");
            AssertUtils.checkArgument(form.containsAllValues(FormValueNames.NAMES_GENERAL_STATE), CommonMessages.MSG_INV_RESP);
            FormDataUtils.setValue(form, "__EVENTTARGET", "ctl00$ContentBody$ProfilePanel1$lnkUserStats");
            String postUrl = URLUtils.absAsString(doc.baseUri(), form.getAction());
            Request post = RequestUtils.post(postUrl, form.getFormData());
            if (monitor.isCanceled()) {
                return null;
            }
            html322 = null;
            Object var10_14 = null;
            try {
                URI baseUri;
                WebResponse response;
                block31: {
                    response = this.client.execute(post);
                    baseUri = response.getLastURI();
                    if (!monitor.isCanceled()) break block31;
                    if (response == null) return null;
                    response.close();
                    return null;
                }
                try {
                    String html2 = response.getContentText();
                    this.writeFile("profile-2.txt", html2);
                    doc = Jsoup.parse((String)html2, (String)baseUri.toASCIIString());
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (html322 == null) {
                    html322 = throwable2;
                    throw html322;
                }
                if (html322 == throwable2) throw html322;
                ((Throwable)html322).addSuppressed(throwable2);
                throw html322;
            }
            data = new DocumentData((Element)doc);
            GcLoginAssert.checkLoggedIn(doc, data, info);
            ProfileGeocachesParser parser = new ProfileGeocachesParser((Element)doc);
            GeocacheTypeCounter stats = parser.getGeocacheTypeStats();
            monitor.worked(1);
            GeocacheTypeCounter geocacheTypeCounter = stats;
            return geocacheTypeCounter;
        }
        catch (ParseException e) {
            log.debug((Object)"Exception", (Throwable)e);
            monitor.done();
            MessageUtils.showParseException(e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public void getFieldNoteDetails(AsyncContext ctx, FieldNoteItem item) throws IOException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_FIELD_NOTES);
        AssertUtils.notNull(ctx, "Context");
        AssertUtils.notNull(item, "Field Note item");
        String refCode = item.getRefCode();
        AssertUtils.notNull(refCode, "Reference Code");
        try {
            GcAuthToken token = this.getAuthToken(ctx, info);
            String url = String.format("/api/proxy/web/v1/LogDrafts/%s", refCode);
            Request request = RequestUtils.get(GcWebService.getUrl(url));
            Throwable throwable = null;
            Object var9_12 = null;
            try (WebResponse response = this.client.execute(request);){
                String resp = response.getContentText();
                LinkedList items = new LinkedList();
                DataStoreListAdapter store = new DataStoreListAdapter(items);
                DataReaderContext rctx = DataReaderUtils.createDataReaderContext(ctx.getMonitor(), store);
                LogDraftsDataParser parser = new LogDraftsDataParser(rctx);
                JsonParser.parse(resp, (IUserParser)parser);
                if (items.size() > 0) {
                    FieldNoteItem i = (FieldNoteItem)items.get(0);
                    item.setLogText(i.getLogText());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParseException e) {
            log.debug((Object)"Error", (Throwable)e);
            ctx.getMonitor().done();
            MessageUtils.showParseException(e);
        }
        catch (ParserException e) {
            log.debug((Object)"Error", (Throwable)e);
            ctx.getMonitor().done();
            MessageUtils.showException(e);
        }
    }

    private void deleteLogDraft(AsyncContext ctx, String refCode) throws IOException, ParseException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_DELETE_FIELD_NOTE);
        AssertUtils.notNull(ctx, "Context");
        AssertUtils.notNull(refCode, "Reference Code");
        log.trace((Object)String.format("Deleting log draft: %s", refCode));
        GcAuthToken token = this.getAuthToken(ctx, info);
        String url = String.format("/api/proxy/web/v1/LogDrafts/%s", refCode);
        Request request = RequestUtils.delete(GcWebService.getUrl(url));
        Throwable throwable = null;
        Object var8_8 = null;
        try {
            WebResponse response = this.client.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public PostLogResult postLog(AsyncContext ctx, FieldNoteItem item) throws InvalidLogTypeException, IOException, ParseException, LoginRequiredException {
        AssertUtils.notNull(ctx, "ctx");
        AssertUtils.notNull(item, "item");
        String code = item.getGeocacheCode();
        AssertUtils.notNull(code, "Geocache code");
        URI link = item.getNewLogLink();
        AssertUtils.notNull(link, "Log link");
        GeocacheLogType logType = item.getLogType();
        AssertUtils.notNull((Object)logType, "Log type");
        Date logDate = item.getLogDate();
        AssertUtils.notNull(logDate, "Log date");
        String logText = item.getLogTextFormatted();
        AssertUtils.notEmpty(logText, "Log Text");
        boolean addFav = item.getFavourite();
        boolean visitTrackables = item.getVisitTrackables();
        this.postLog(ctx, code, link, logType, logDate, logText, addFav, visitTrackables);
        item.setComposeLink(null);
        item.setDeleteLink(null);
        String refCode = item.getRefCode();
        if (StringUtils.notEmpty(refCode)) {
            try {
                this.deleteLogDraft(ctx, refCode);
            }
            catch (Exception e) {
                log.debug((Object)"Error", (Throwable)e);
            }
            item.setRefCode(null);
        }
        return new PostLogResult(PostLogResult.Status.POSTED);
    }

    private void postLog(AsyncContext ctx, String code, URI link, GeocacheLogType logType, Date logDate, String logText, boolean addFav, boolean visitTrackables) throws InvalidLogTypeException, IOException, ParseException, LoginRequiredException {
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_POST_LOG);
        String timestamp = DateUtils.getCurrentTimestamp();
        Request request = RequestUtils.get(link.toASCIIString());
        log.trace((Object)String.format("Requesting log page: %s", link));
        Document doc = null;
        Throwable throwable = null;
        Object var14_15 = null;
        try (WebResponse response = this.client.execute(request);){
            URI baseUri = response.getLastURI();
            String html = response.getContentText();
            String filename = String.format("log-%s-req.txt", timestamp);
            this.writeFile(filename, html);
            doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DocumentData data = new DocumentData((Element)doc);
        GcLoginAssert.checkLoggedIn(doc, data, info);
        FormData form = data.getMatchingForm(FormValueNames.NAMES_CREATE_LOG_NEW);
        AssertUtils.checkArgument(form != null, CommonMessages.MSG_INV_RESP);
        if (form != null) {
            EmbeddedJsonParser nextData = new EmbeddedJsonParser((Element)doc, "__NEXT_DATA__");
            Integer logTypeId = this.mapLogType(logType);
            if (logType == GeocacheLogType.FOUND_IT && !nextData.isLogTypeIdValid(logTypeId) && !nextData.isLogTypeIdValid(logTypeId = this.mapLogType(GeocacheLogType.ATTENDED))) {
                logTypeId = this.mapLogType(GeocacheLogType.WEBCAM_PHOTO_TAKEN);
            }
            if (!nextData.isLogTypeIdValid(logTypeId)) {
                throw new InvalidLogTypeException(logType);
            }
            JSONArray trackables = JSONUtils.createArray();
            if (visitTrackables) {
                nextData.trackables.forEach(item -> {
                    if (!StringUtils.equalsIgnoreCase(item, "TB27DT6")) {
                        JSONObject t = JSONUtils.createObject(trackables);
                        t.put("trackableCode", item);
                        t.put("trackableLogTypeId", 75);
                    }
                });
            }
            JSONObject payload = JSONUtils.createObject();
            payload.put("images", (Collection)Collections.EMPTY_LIST);
            payload.put("logDate", (Object)DateUtils.formatDateGMTExt(logDate));
            payload.put("logText", (Object)logText);
            payload.put("logType", (Object)logTypeId);
            payload.put("trackables", (Object)trackables);
            String postUrl = String.format("/api/live/v1/logs/%s/geocacheLog", code);
            String csrfToken = this.getCsrfToken(ctx, info);
            LinkedList<StringPair> headers = new LinkedList<StringPair>();
            headers.add(new StringPair("CSRF-Token", csrfToken));
            Request post = RequestUtils.post(GcWebService.getUrl(postUrl), headers, payload);
            Throwable throwable3 = null;
            Object var24_27 = null;
            try (WebResponse response = this.client.execute(post);){
                String text = response.getContentText();
                String filename = String.format("log-%s-resp.txt", timestamp);
                this.writeFile(filename, text);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
    }

    protected void printFormData(FormData data) {
        if (data != null) {
            this.print("Form: name=%s, action=%s, method=%s", data.getName(), data.getAction(), data.getMethod());
            this.print("Form elements: %d", data.getElementCount());
            for (FormElement input : data.getElements()) {
                this.print("%s", input);
            }
            this.print("Form values: %d", data.getValueCount());
            for (FormValue value : data.getValues()) {
                this.print("%s", value);
            }
            this.print("", new Object[0]);
        }
    }

    protected void printFormValue(FormValue value) {
        if (value != null) {
            if (value.isSelectable()) {
                this.print("Form value: name=%s, type=%s (%s)", value.getName(), value.getName(), value.isMultiSelectable() ? "multi" : "single");
                List<FormValueOption> options = value.getOptions();
                if (options != null) {
                    for (FormValueOption option : options) {
                        this.print("%s", option);
                    }
                }
            } else {
                this.print("Form value: name=%s, type=%s, value=%s", value.getName(), value.getType(), value.getValue());
            }
        }
    }

    protected void writeFile(String filename, String data) throws IOException {
        if (this.logPages) {
            FileUtils.writeFile(FileUtils.combinePath(LOGS_PATH, filename), data);
        }
    }
}

