/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.mappers.Id2LogTypeMapper;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteType;
import geocentral.common.geocaching.DefaultGeocacheLogTypeMapper;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheMapperUtils;
import geocentral.common.geocaching.GeocacheSite;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.URLUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateFormatHelper;
import org.bacza.utils.DateParser;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FieldNoteParser {
    private static final DefaultGeocacheLogTypeMapper logTypeMapper = GeocacheMapperUtils.getLogTypeMapper();
    private static final Id2LogTypeMapper id2LogTypeMapper = new Id2LogTypeMapper();
    private static final DateParser DP_LOG_DATE = FieldNoteParser.createDateParser();
    private List<FieldNoteItem> fieldNotes = new LinkedList<FieldNoteItem>();
    private List<FieldNoteItem> fieldNotesIncomplete = new LinkedList<FieldNoteItem>();

    private static DateParser createDateParser() {
        DateParser dp = new DateParser();
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dp.addFormat(new DateFormatHelper("dd MMM yyyy HH:mm:ss", tz));
        dp.addFormat(new DateFormatHelper("dd MMM yyyy", tz));
        return dp;
    }

    public FieldNoteParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        Element div = root.getElementById("divContentMain");
        ParseAssert.notNull(div, 1000);
        Element tab = div.getElementsByTag("table").first();
        if (tab == null) {
            return;
        }
        Elements rows = tab.select("tbody > tr");
        ParseAssert.notNull(rows, 1020);
        for (Element row : rows) {
            FieldNoteItem meta = new FieldNoteItem();
            meta.setFieldNoteType(FieldNoteType.ONLINE);
            meta.setSite(GeocacheSite.GC);
            Elements cols = row.getElementsByTag("td");
            ParseAssert.check(cols.size() == 5, 1030);
            Element a = cols.get(1).getElementsByTag("a").first();
            ParseAssert.notNull(a, 1031);
            String name = a.text();
            ParseAssert.notEmpty(name, 1032);
            meta.setGeocacheName(name);
            String geocacheLink = URLUtils.decode(a.attr("href"));
            String geocacheGuid = URLUtils.getParamValue(geocacheLink, "guid");
            ParseAssert.notEmpty(geocacheGuid, 1033);
            meta.setGuid(geocacheGuid);
            String logDateStr = cols.get(2).text();
            Date logDate = DP_LOG_DATE.parse(logDateStr);
            ParseAssert.notNull(logDate, 1034);
            meta.setLogDate(logDate);
            Element col3 = cols.get(3);
            GeocacheLogType logType = null;
            if (logType == null) {
                logType = this.getLogTypeByImg(col3);
            }
            if (logType == null) {
                logType = this.getLogTypeByText(col3);
            }
            meta.setLogType(logType);
            Elements links = cols.get(4).getElementsByTag("a");
            ParseAssert.check(links.size() == 2, 1036);
            String href = links.get(0).attr("href");
            if (StringUtils.contains(href, "fieldnotes.aspx") && URLUtils.hasParam(href, "composeLog")) {
                meta.setComposeLink(URLUtils.abs(root.baseUri(), href));
            }
            ParseAssert.notNull(meta.getComposeLink(), 1040);
            href = links.get(1).attr("href");
            if (StringUtils.contains(href, "fieldnotes.aspx") && URLUtils.hasParam(href, "PLogD")) {
                meta.setDeleteLink(URLUtils.abs(root.baseUri(), href));
            }
            ParseAssert.notNull(meta.getDeleteLink(), 1041);
            this.fieldNotes.add(meta);
            if (meta.getLogType() != null) continue;
            this.fieldNotesIncomplete.add(meta);
        }
    }

    private GeocacheLogType getLogTypeByImg(Element element) {
        String src;
        Element img;
        if (element != null && (img = element.getElementsByTag("img").first()) != null && (src = img.attr("src")) != null) {
            String logTypeStr = src.replaceAll(".+/([^.]+).(gif|png)", "$1");
            return id2LogTypeMapper.getMappedValue(logTypeStr, null);
        }
        return null;
    }

    private GeocacheLogType getLogTypeByText(Element element) {
        if (element != null) {
            String logTypeStr = element.text();
            if (StringUtils.notEmpty(logTypeStr)) {
                logTypeStr = logTypeStr.replace("\u00a0", "");
            }
            return logTypeMapper.getMappedValue(logTypeStr, null);
        }
        return null;
    }

    public List<FieldNoteItem> getFieldNotes() {
        return this.fieldNotes;
    }

    public List<FieldNoteItem> getFieldNotesIncomplete() {
        return this.fieldNotesIncomplete;
    }
}

